/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.sequence.BasicSequence;
import org.forester.sequence.MolecularSequence;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class check_fasta {
    private static final String PRG_NAME = "check_fasta";
    private static final String PRG_VERSION = "1.00";
    private static final String PRG_DATE = "131202";

    public static void main(String[] stringArray) {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE);
        System.out.println();
        if (stringArray.length != 2) {
            check_fasta.argumentsError();
        }
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        if (!file.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, file + " is not a directory");
        }
        if (!file2.isDirectory()) {
            ForesterUtil.fatalError(PRG_NAME, file2 + " is not a directory");
        }
        File[] fileArray = file.listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file3 : fileArray) {
            if (!file3.isFile() || !file3.canRead() || !file3.toString().toLowerCase().endsWith(".fasta") && !file3.toString().toLowerCase().endsWith(".fas")) continue;
            arrayList.add(file3);
        }
        Collections.sort(arrayList);
        int n = 0;
        for (File file4 : arrayList) {
            System.out.println(++n + "/" + arrayList.size() + ": " + file4);
            check_fasta.execute(file2, file4);
        }
    }

    private static void execute(File file, File file2) {
        File file3 = new File(file.getAbsolutePath().toString() + "/" + file2.getName());
        if (file3.exists()) {
            System.out.println(file3 + " already exists");
        } else {
            try {
                List<MolecularSequence> list = FastaParser.parse(new FileInputStream(file2));
                HashMap<String, Short> hashMap = new HashMap<String, Short>();
                int n = 0;
                for (MolecularSequence molecularSequence : list) {
                    if (!check_fasta.procSeq(file2.toString(), hashMap, molecularSequence)) continue;
                    ++n;
                }
                if (n > 0) {
                    SequenceWriter.writeSeqs(list, file3, SequenceWriter.SEQ_FORMAT.FASTA, 60);
                }
            }
            catch (IOException iOException) {
                ForesterUtil.fatalError(PRG_NAME, iOException.getMessage());
            }
        }
    }

    private static boolean procSeq(String string, Map<String, Short> map, MolecularSequence molecularSequence) {
        boolean bl = false;
        String string2 = molecularSequence.getIdentifier();
        if (!map.containsKey(string2)) {
            map.put(string2, (short)1);
        } else {
            bl = true;
            short s = map.get(string2);
            ((BasicSequence)molecularSequence).setIdentifier(string2 + "_" + s);
            map.put(string2, (short)(s + 1));
            System.out.println("  " + string + " " + s + ": " + molecularSequence.getIdentifier());
        }
        return bl;
    }

    private static void argumentsError() {
        System.out.println("check_fasta <indir> <outdir>");
        System.out.println();
        System.exit(-1);
    }
}

