/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.dnd;

import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.track.Track;
import org.broad.igv.ui.panel.TrackPanel;

public class GhostDropEvent {
    private Point point;
    private Point startPoint;
    List<Track> tracks;
    List<TrackPanel> sourcePanels;
    boolean tracksDropped = false;

    public GhostDropEvent(Point startPoint, Point point, List<Track> tracks) {
        this.startPoint = startPoint;
        this.point = point;
        this.tracks = tracks;
        this.sourcePanels = new ArrayList<TrackPanel>();
    }

    public void addSourcePanel(TrackPanel panel) {
        this.sourcePanels.add(panel);
    }

    public void setTracksDropped(boolean bool) {
        this.tracksDropped = bool;
    }

    public boolean isTracksDropped() {
        return this.tracksDropped;
    }

    public void removeTracksFromSource() {
        for (TrackPanel panel : this.sourcePanels) {
            panel.removeTracks(this.tracks);
        }
        this.sourcePanels.clear();
    }

    public Point getStartLocation() {
        return this.startPoint;
    }

    public Point getDropLocation() {
        return this.point;
    }

    public List<Track> getTracks() {
        return this.tracks;
    }
}

