/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.LocusScore;

public class SummaryTile2D {
    private int tileNumber;
    private int startLocation;
    Map<Integer, List<LocusScore>> summaryScores;

    public SummaryTile2D(int tileNumber, int startLocation) {
        this.tileNumber = tileNumber;
        this.startLocation = startLocation;
        this.summaryScores = new HashMap<Integer, List<LocusScore>>();
    }

    public void addScore(int trackNumber, LocusScore score) {
        List<LocusScore> scoreList = this.summaryScores.get(trackNumber);
        if (scoreList == null) {
            scoreList = new ArrayList<LocusScore>();
            this.summaryScores.put(trackNumber, scoreList);
        }
        scoreList.add(score);
    }

    public List<LocusScore> getScores(int trackNumber) {
        return this.summaryScores.get(trackNumber);
    }

    public Map<Integer, List<LocusScore>> getSummaryScores() {
        return this.summaryScores;
    }

    public int getSize() {
        return this.summaryScores.size();
    }

    public boolean isEmpty() {
        return this.summaryScores.isEmpty();
    }

    public int getStartLocation() {
        return this.startLocation;
    }
}

