/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util.barcode;

import it.unimi.dsi.fastutil.ints.Int2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.lang.MutableString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.util.barcode.BarcodeMatcherResult;

public abstract class BarcodeMatcher {
    private static final Log LOG = LogFactory.getLog(BarcodeMatcher.class);
    protected final Int2LongMap barcodeIndexToHitsMap = new Int2LongLinkedOpenHashMap();
    protected MutableString[] barcodes;
    protected int barcodeLength;
    protected int allowedMismatches;

    public void init(String[] barcodesStrArray, int barcodeLength, int allowedMismatches) {
        if (barcodesStrArray != null) {
            this.barcodes = new MutableString[barcodesStrArray.length];
            for (int i = 0; i < barcodesStrArray.length; ++i) {
                this.barcodes[i] = new MutableString(barcodesStrArray[i]);
                this.barcodeIndexToHitsMap.put(i, 0L);
            }
        } else {
            this.barcodes = null;
        }
        this.barcodeLength = barcodeLength;
        this.allowedMismatches = allowedMismatches;
    }

    BarcodeMatcherResult bestMatch(MutableString sequence, MutableString toFind, int barcodeNum) {
        return this.bestMatch(sequence, toFind, barcodeNum, this.barcodeLength);
    }

    abstract BarcodeMatcherResult bestMatch(MutableString var1, MutableString var2, int var3, int var4);

    public BarcodeMatcherResult matchSequence(MutableString sequence) {
        BarcodeMatcherResult bestMatch = null;
        int numAtBestMatch = 0;
        for (int barcodeNum = 0; barcodeNum < this.barcodes.length; ++barcodeNum) {
            MutableString barcode = this.barcodes[barcodeNum];
            BarcodeMatcherResult result = this.bestMatch(sequence, barcode, barcodeNum);
            if (bestMatch == null) {
                numAtBestMatch = 1;
                bestMatch = result;
            } else if (result.getNumberOfDiffs() < bestMatch.getNumberOfDiffs()) {
                numAtBestMatch = 1;
                bestMatch = result;
            } else if (result.getNumberOfDiffs() == bestMatch.getNumberOfDiffs()) {
                ++numAtBestMatch;
            }
            if (bestMatch.getNumberOfDiffs() == 0) break;
        }
        if (bestMatch == null || bestMatch.getNumberOfDiffs() > this.allowedMismatches) {
            return null;
        }
        if (numAtBestMatch > 1) {
            bestMatch.setAmbiguous(true);
        }
        int bestBarcodeNum = bestMatch.getBarcodeIndex();
        this.barcodeIndexToHitsMap.put(bestBarcodeNum, this.barcodeIndexToHitsMap.get(bestBarcodeNum) + 1L);
        return bestMatch;
    }

    public Int2LongMap getBarcodeIndexToHitsMap() {
        return this.barcodeIndexToHitsMap;
    }

    public MutableString getBarcodeWithAdapterAtIndex(int index) {
        return this.barcodes[index];
    }

    public MutableString getBarcodeOnlyAtIndex(int index) {
        return this.barcodes[index].substring(0, this.barcodeLength);
    }

    public int getBarcodeLength() {
        return this.barcodeLength;
    }

    public int getAllowedMismatches() {
        return this.allowedMismatches;
    }

    int numDifferences(MutableString a, MutableString b, int aStart, int bStart, int matchLength) {
        int numDifferences = 0;
        for (int i = 0; i < matchLength && (a.charAt(aStart + i) == b.charAt(bStart + i) || ++numDifferences <= this.allowedMismatches); ++i) {
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Comparing %s and %s (diff=%d)", a.substring(aStart, aStart + matchLength), b.substring(bStart, bStart + matchLength), numDifferences));
        }
        return numDifferences;
    }
}

