/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.perms;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.util.IOUtil;

public class PermutationWriter
implements Closeable {
    private static final Log LOG = LogFactory.getLog(PermutationWriter.class);
    private final String basename;
    private final DataOutputStream output;
    private int numWritten;
    private int chunkSize = 1000;
    private int previousWritten = 0;

    public PermutationWriter(String basename) {
        this.basename = AlignmentReaderImpl.getBasename(basename);
        DataOutputStream o = null;
        try {
            o = new DataOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(basename + ".perm")));
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)e);
            o = null;
        }
        this.output = o;
    }

    @Override
    public void close() {
        IOUtil.closeQuietly(this.output);
    }

    public void append(Int2IntMap permPiece) throws IOException {
        if (permPiece.isEmpty()) {
            return;
        }
        IntArrayList smallIndices = new IntArrayList();
        smallIndices.addAll(permPiece.values());
        Collections.sort(smallIndices);
        int size = smallIndices.size();
        int minSmallIndexInChunk = smallIndices.get(0);
        int maxSmallIndexInChunk = smallIndices.get(size - 1);
        IntArrayList largeIndices = new IntArrayList();
        largeIndices.size(permPiece.size());
        IntIterator intIterator = permPiece.keySet().iterator();
        while (intIterator.hasNext()) {
            int queryIndex = (Integer)intIterator.next();
            int smallIndex = permPiece.get(queryIndex);
            int indexOf = Collections.binarySearch(smallIndices, smallIndex);
            largeIndices.set(indexOf, queryIndex);
        }
        this.chunk(smallIndices, minSmallIndexInChunk, maxSmallIndexInChunk, largeIndices);
        this.output.flush();
    }

    private void chunk(IntArrayList smallIndices, int minSmallIndexInChunk, int maxSmallIndexInChunk, IntArrayList largeIndices) throws IOException {
        int max = smallIndices.size();
        int breakpointIndex = -1;
        while (this.previousWritten < max) {
            breakpointIndex = this.getBreakPoint(Math.max(0, this.previousWritten), smallIndices);
            this.write(this.previousWritten, smallIndices, breakpointIndex, largeIndices);
            this.previousWritten = breakpointIndex;
        }
    }

    private void write(int previousWritten, IntArrayList smallIndices, int breakpointIndex, IntArrayList largeIndices) throws IOException {
        int firstSmallIndex = smallIndices.get(previousWritten);
        this.writeOnePiece(previousWritten, firstSmallIndex, largeIndices, breakpointIndex - previousWritten);
        this.output.flush();
    }

    public void writeOnePiece(int firstSmallIndex, IntArrayList largeIndices) throws IOException {
        this.writeOnePiece(0, firstSmallIndex, largeIndices, largeIndices.size());
        this.output.flush();
    }

    public void writeOnePiece(int previousWritten, int firstSmallIndex, IntArrayList largeIndices, int n) throws IOException {
        this.output.writeInt(n);
        this.output.writeInt(firstSmallIndex);
        int pastLast = n + previousWritten;
        for (int i = previousWritten; i < pastLast; ++i) {
            this.output.writeInt(largeIndices.get(i));
        }
        this.numWritten += n;
    }

    protected int getBreakPoint(int previousWritten, IntArrayList smallIndices) throws IOException {
        return this.getBreakPoint(previousWritten, smallIndices, this.chunkSize);
    }

    protected int getBreakPoint(int previousWritten, IntArrayList smallIndices, int chunkSize) throws IOException {
        if (previousWritten >= smallIndices.size()) {
            return smallIndices.size();
        }
        int index = 0;
        int previousSmallIndex = smallIndices.get(previousWritten);
        int n = Math.min(chunkSize, smallIndices.size() - previousWritten);
        for (int numInChunk = 0; numInChunk < n; ++numInChunk) {
            int offset = index + previousWritten;
            int smallIndex = smallIndices.get(offset);
            if (numInChunk > 0 && smallIndex != previousSmallIndex + 1) {
                return offset;
            }
            previousSmallIndex = smallIndex;
            ++index;
        }
        return index + previousWritten;
    }
}

