/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.util;

import com.ibm.icu.text.Transliterator;
import org.apache.unicode.UnicodeCharUtil;

public class ICBStringNormalizer {
    private static final Transliterator ACCENTS_REMOVER = Transliterator.getInstance((String)"NFD; [:M:] Remove; NFC;");

    private ICBStringNormalizer() {
    }

    public static String removeAccents(String accentedValue) {
        String noAccents = ACCENTS_REMOVER.transliterate(accentedValue);
        int length = noAccents.length();
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char curChar = noAccents.charAt(i);
            if (UnicodeCharUtil.isCombiningCharacter(curChar) || UnicodeCharUtil.isSpacingModifier(curChar)) continue;
            char foldC = UnicodeCharUtil.foldNonDiacriticChar(curChar);
            if (foldC == '\u0000') {
                result.append(curChar);
                continue;
            }
            result.append(foldC);
        }
        return result.toString();
    }
}

