/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import com.pugh.sockso.music.tag.AudioTag;
import java.io.File;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class Mp3Tag
extends AudioTag {
    public void parse(File file) {
        try {
            MP3File f = (MP3File)AudioFileIO.read((File)file);
            if (f.hasID3v2Tag()) {
                this.parseID3v2Tag(f);
            }
            if (f.hasID3v1Tag()) {
                this.parseID3v1Tag(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parseID3v2Tag(MP3File f) {
        ID3v24Tag v2tag = f.getID3v2TagAsv24();
        this.artistTitle = v2tag.getFirst("TPE1");
        this.albumTitle = v2tag.getFirst("TALB");
        this.trackTitle = v2tag.getFirst("TIT2");
        this.albumYear = v2tag.getFirst("TDRC");
        String trackN = v2tag.getFirst("TRCK");
        try {
            this.trackNumber = Integer.parseInt(trackN);
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
    }

    private void parseID3v1Tag(MP3File f) {
        ID3v1Tag tag = f.getID3v1Tag();
        try {
            if (this.artistTitle.equals("")) {
                this.artistTitle = new String(((TagField)tag.getArtist().get(0)).toString());
            }
            if (this.albumTitle.equals("")) {
                this.albumTitle = new String(((TagField)tag.getAlbum().get(0)).toString());
            }
            if (this.trackTitle.equals("")) {
                this.trackTitle = new String(((TagField)tag.getTitle().get(0)).toString());
            }
            if (this.albumYear.equals("")) {
                this.albumYear = new String(((TagField)tag.getYear().get(0)).toString());
            }
            if (this.trackNumber == 0) {
                try {
                    String trackN = new String(((TagField)tag.getTrack().get(0)).toString());
                    this.trackNumber = Integer.parseInt(trackN);
                }
                catch (NumberFormatException ignored) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

