/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.commands.BaseCommand;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import java.io.File;

public class ColAdd
extends BaseCommand {
    private final Locale locale;
    private final CollectionManager cm;

    public ColAdd(CollectionManager cm, Locale locale) {
        this.cm = cm;
        this.locale = locale;
    }

    public String getName() {
        return "coladd";
    }

    public String getDescription() {
        return "Adds a folder to the collection";
    }

    public String execute(String[] args) {
        String path = args[1];
        File file = new File(path);
        if (file.exists()) {
            this.cm.addDirectory(file);
            return this.locale.getString("con.msg.directoryAdded");
        }
        return this.locale.getString("con.err.pathNotExist", new String[]{path});
    }

    public int getNumArgs() {
        return 1;
    }

    public String[] getArguments() {
        return new String[]{"PATH"};
    }
}

