/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Utils;
import java.io.IOException;
import java.net.UnknownHostException;
import net.sbbi.upnp.impls.InternetGatewayDevice;
import net.sbbi.upnp.messages.UPNPResponseException;
import org.apache.log4j.Logger;

public class UPNP {
    private static final int TIMEOUT_SECS = 3;
    private static final Logger log = Logger.getLogger(UPNP.class);

    public static InternetGatewayDevice[] getRouterDevices() throws IOException {
        log.debug((Object)"Searching for devices");
        return InternetGatewayDevice.getDevices((int)3000);
    }

    public static boolean forwardPort(InternetGatewayDevice device, int port) throws UnknownHostException, IOException, UPNPResponseException {
        String localHostIP = Utils.getLocalIp();
        boolean success = device.addPortMapping("Sockso", null, port, port, localHostIP, 0, "TCP");
        if (success) {
            log.debug((Object)("Port " + port + " forwarded"));
        }
        return success;
    }

    public static void tryPortForwarding(int port) {
        try {
            InternetGatewayDevice[] devices = UPNP.getRouterDevices();
            if (devices != null && devices.length > 0) {
                log.debug((Object)("Found device " + devices[0].getIGDRootDevice().getModelName()));
                UPNP.forwardPort(devices[0], port);
            } else {
                log.debug((Object)"No devices found");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }
}

