/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Properties;
import com.pugh.sockso.PropertiesListener;
import com.pugh.sockso.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.log4j.Logger;

public class CommunityUpdater
extends Thread
implements PropertiesListener {
    private static final Logger log = Logger.getLogger(CommunityUpdater.class);
    private final int MINUTES_BETWEEN_PINGS = 15;
    private final Properties p;

    public CommunityUpdater(Properties p) {
        this.p = p;
        p.addPropertiesListener(this);
    }

    public void propertiesSaved(Properties p) {
        this.interrupt();
    }

    public void run() {
        while (true) {
            this.check();
            try {
                Thread.sleep(900000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    protected void check() {
        if (this.p.get("community.enabled").equals("yes")) {
            this.ping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping() {
        block6: {
            BufferedReader in = null;
            OutputStreamWriter wr = null;
            try {
                String line;
                String pingUrl = this.getPingUrl();
                HttpURLConnection cnn = this.getUrlConnection(pingUrl);
                String json = "{ \"skey\":      \"" + this.getKey() + "\", " + " \"port\":      \"" + this.p.get("server.port") + "\", " + " \"basepath\":  \"" + this.p.get("server.basepath") + "\" " + "}";
                cnn.setDoOutput(true);
                log.debug((Object)("Ping community server: " + json));
                wr = new OutputStreamWriter(cnn.getOutputStream());
                wr.write(json);
                wr.flush();
                in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
                while ((line = in.readLine()) != null) {
                    log.debug((Object)("Ping response: " + line));
                }
                Utils.close(wr);
            }
            catch (IOException e) {
                log.error((Object)e);
                break block6;
            }
            finally {
                Utils.close(wr);
                Utils.close(in);
            }
            Utils.close(in);
        }
    }

    protected HttpURLConnection getUrlConnection(String url) throws IOException {
        return (HttpURLConnection)new URL(url).openConnection();
    }

    protected String getPingUrl() {
        return this.p.get("community.pingUrl", "http://sockso.pu-gh.com/community/ping");
    }

    private String getKey() {
        String key = this.p.get("server.key", "");
        if (key.length() == 0) {
            key = Utils.getRandomString(32);
            this.p.set("server.key", key);
            this.p.save();
        }
        return key;
    }
}

