/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.metadata;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueFactoryMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.beans.metadata.spi.builder.ParameterMetaDataBuilder;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.logging.metadata.AbstractHandlerMetaData;
import org.jboss.logging.metadata.AbstractLoggerMetaData;
import org.jboss.logging.metadata.AbstractLoggerRefMetaData;
import org.jboss.logging.metadata.AbstractMultiFilterMetaData;
import org.jboss.logging.metadata.AcceptFilterMetaData;
import org.jboss.logging.metadata.AllFilterMetaData;
import org.jboss.logging.metadata.AsyncHandlerMetaData;
import org.jboss.logging.metadata.ClassLoaderRegistrationHelper;
import org.jboss.logging.metadata.ConsoleHandlerMetaData;
import org.jboss.logging.metadata.DefineContextMetaData;
import org.jboss.logging.metadata.DenyFilterMetaData;
import org.jboss.logging.metadata.ErrorManagerMetaData;
import org.jboss.logging.metadata.FileHandlerMetaData;
import org.jboss.logging.metadata.FilterMetaData;
import org.jboss.logging.metadata.FormatterMetaData;
import org.jboss.logging.metadata.GetClassLoaderBeanMetaData;
import org.jboss.logging.metadata.HandlerInstallerHelper;
import org.jboss.logging.metadata.HandlerMetaData;
import org.jboss.logging.metadata.InstallHandlerMetaData;
import org.jboss.logging.metadata.LevelChangeFilterMetaData;
import org.jboss.logging.metadata.LevelFilterMetaData;
import org.jboss.logging.metadata.LevelRangeFilterMetaData;
import org.jboss.logging.metadata.Log4jAppenderMetaData;
import org.jboss.logging.metadata.LoggerMetaData;
import org.jboss.logging.metadata.LoggerRefMetaData;
import org.jboss.logging.metadata.LoggingMetaData;
import org.jboss.logging.metadata.MatchFilterMetaData;
import org.jboss.logging.metadata.NotFilterMetaData;
import org.jboss.logging.metadata.NullHandlerMetaData;
import org.jboss.logging.metadata.PatternFormatterMetaData;
import org.jboss.logging.metadata.PeriodicRotatingFileHandlerMetaData;
import org.jboss.logging.metadata.RefMetaData;
import org.jboss.logging.metadata.ReplaceFilterMetaData;
import org.jboss.logging.metadata.SizeRotatingFileHandlerMetaData;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.errormanager.OnlyOnceErrorManager;
import org.jboss.logmanager.filters.AcceptAllFilter;
import org.jboss.logmanager.filters.AllFilter;
import org.jboss.logmanager.filters.AnyFilter;
import org.jboss.logmanager.filters.DenyAllFilter;
import org.jboss.logmanager.filters.InvertFilter;
import org.jboss.logmanager.filters.LevelChangingFilter;
import org.jboss.logmanager.filters.LevelFilter;
import org.jboss.logmanager.filters.LevelRangeFilter;
import org.jboss.logmanager.filters.RegexFilter;
import org.jboss.logmanager.filters.SubstituteFilter;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.NullHandler;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.logmanager.log4j.handlers.Log4jAppenderHandler;

public final class LoggingMetaDataHelper {
    private static final AtomicInteger sequence = new AtomicInteger();
    private static final Map<ConsoleHandlerMetaData.Target, ConsoleHandler.Target> targetMap = new EnumMap<ConsoleHandlerMetaData.Target, ConsoleHandler.Target>(ConsoleHandlerMetaData.Target.class);
    private static final Pattern SIZE_PATTERN;

    private LoggingMetaDataHelper() {
    }

    public static void createBeanMetaData(List<BeanMetaData> beanMetaDataList, LoggingMetaData loggingMetaData) {
        List<InstallHandlerMetaData> installHandlerMetaDataList;
        List<AbstractHandlerMetaData> handlerMetaDataList;
        List<AbstractLoggerMetaData> abstractLoggerMetaDataList;
        String context = loggingMetaData.getContext();
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        List<DefineContextMetaData> defineContextMetaDataList = loggingMetaData.getDefineContextMetaDataList();
        if (defineContextMetaDataList != null) {
            for (DefineContextMetaData defineContextMetaData : defineContextMetaDataList) {
                String contextName = defineContextMetaData.getName();
                BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)LoggingMetaDataHelper.getContextName(contextName == null ? context : contextName), (String)LogContext.class.getName());
                builder.setFactoryMethod("create");
                beanMetaDataList.add(builder.getBeanMetaData());
            }
        }
        if (!context.equals("system")) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((BeanMetaData)new GetClassLoaderBeanMetaData(LoggingMetaDataHelper.getAnonymousName(context, Kind.REGISTRATION), ClassLoaderRegistrationHelper.class.getName()));
            builder.addPropertyMetaData("logContext", builder.createInject((Object)LoggingMetaDataHelper.getContextName(context)));
            builder.addPropertyMetaData("selector", builder.createInject((Object)"JBossLogManagerContextSelectorService"));
            beanMetaDataList.add(builder.getBeanMetaData());
        }
        if ((abstractLoggerMetaDataList = loggingMetaData.getLoggerMetaDataList()) != null) {
            for (AbstractLoggerMetaData abstractLoggerMetaData : abstractLoggerMetaDataList) {
                LoggingMetaDataHelper.createLoggerBeanMetaData(beanMetaDataList, abstractLoggerMetaData, context);
            }
        }
        if ((handlerMetaDataList = loggingMetaData.getHandlerMetaDataList()) != null) {
            for (AbstractHandlerMetaData abstractHandlerMetaData : handlerMetaDataList) {
                LoggingMetaDataHelper.getValue(beanMetaDataList, abstractHandlerMetaData, context);
            }
        }
        if ((installHandlerMetaDataList = loggingMetaData.getInstallHandlerMetaDataList()) != null) {
            for (InstallHandlerMetaData installMetaData : installHandlerMetaDataList) {
                String installerName = LoggingMetaDataHelper.getInstallerName(context, "*");
                RefMetaData handlerRef = installMetaData.getHandlerRef();
                List<AbstractLoggerRefMetaData> loggerRefs = installMetaData.getLoggerRefList();
                BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)installerName, (String)HandlerInstallerHelper.class.getName());
                List handlerList = builder.createList();
                List targetList = builder.createList();
                handlerList.add(builder.createInject((Object)LoggingMetaDataHelper.getName(context, Kind.HANDLER, handlerRef.getName())));
                for (AbstractLoggerRefMetaData loggerRef : loggerRefs) {
                    String refContext = loggerRef.getContext();
                    String refName = loggerRef instanceof LoggerRefMetaData ? ((LoggerRefMetaData)loggerRef).getCategory() : "";
                    targetList.add(LoggingMetaDataHelper.getLoggerInjectValue(refContext == null ? context : refContext, refName));
                }
                builder.addPropertyMetaData("handlerList", (ValueMetaData)handlerList);
                builder.addPropertyMetaData("targetList", (ValueMetaData)targetList);
                beanMetaDataList.add(builder.getBeanMetaData());
            }
        }
    }

    private static void createLoggerBeanMetaData(List<BeanMetaData> beanMetaDataList, AbstractLoggerMetaData abstractLoggerMetaData, String context) {
        FilterMetaData filterMetaData;
        RefMetaData levelRef;
        String name;
        String humanName;
        if (abstractLoggerMetaData instanceof LoggerMetaData) {
            name = humanName = ((LoggerMetaData)abstractLoggerMetaData).getCategory();
        } else {
            name = "";
            humanName = "<root>";
        }
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)LoggingMetaDataHelper.getName(context, Kind.LOGGER, humanName), (String)Logger.class.getName());
        builder.setFactory(builder.createInject((Object)LoggingMetaDataHelper.getContextName(context)));
        builder.setFactoryMethod("getLogger");
        builder.addConstructorParameter(String.class.getName(), name);
        if (abstractLoggerMetaData instanceof LoggerMetaData) {
            builder.addPropertyMetaData("useParentHandlers", (Object)((LoggerMetaData)abstractLoggerMetaData).isUseParentHandlers());
        }
        if ((levelRef = abstractLoggerMetaData.getLevelMetaData()) != null) {
            builder.addPropertyMetaData("level", LoggingMetaDataHelper.getLevelInjectValue(context, levelRef.getName()));
        }
        if ((filterMetaData = abstractLoggerMetaData.getFilterMetaData()) != null) {
            builder.addPropertyMetaData("filter", LoggingMetaDataHelper.getValue(beanMetaDataList, context, filterMetaData));
        }
        BeanMetaData loggerBeanMetaData = builder.getBeanMetaData();
        List<Object> handlerMetaDataList = abstractLoggerMetaData.getHandlerMetaDataList();
        if (handlerMetaDataList != null) {
            BeanMetaDataBuilder installerBuilder = BeanMetaDataBuilder.createBuilder((String)LoggingMetaDataHelper.getInstallerName(context, name), (String)HandlerInstallerHelper.class.getName());
            List handlerList = builder.createList();
            for (Object handlerMetaData : handlerMetaDataList) {
                if (handlerMetaData instanceof AbstractHandlerMetaData) {
                    handlerList.add(LoggingMetaDataHelper.getValue(beanMetaDataList, (AbstractHandlerMetaData)handlerMetaData, context));
                    continue;
                }
                if (!(handlerMetaData instanceof ValueMetaData)) continue;
                handlerList.add((ValueMetaData)handlerMetaData);
            }
            List targetList = builder.createList();
            targetList.add(loggerBeanMetaData);
            installerBuilder.addPropertyMetaData("handlerList", (ValueMetaData)handlerList);
            installerBuilder.addPropertyMetaData("targetList", (ValueMetaData)targetList);
            beanMetaDataList.add(installerBuilder.getBeanMetaData());
        }
        beanMetaDataList.add(loggerBeanMetaData);
    }

    private static ValueMetaData getValue(List<BeanMetaData> beanMetaDataList, AbstractHandlerMetaData handlerMetaData, String context) {
        List<AbstractLoggerRefMetaData> loggers;
        List<AbstractHandlerMetaData> subHandlers;
        FormatterMetaData formatter;
        FilterMetaData filter;
        RefMetaData levelRef;
        ErrorManagerMetaData errorManager;
        List<PropertyMetaData> properties;
        BeanMetaDataBuilder builder;
        String name = handlerMetaData.getName();
        String targetName = name == null ? LoggingMetaDataHelper.getAnonymousName(context, Kind.HANDLER) : LoggingMetaDataHelper.getName(context, Kind.HANDLER, name);
        BeanMetaDataBuilder propertyTarget = builder = BeanMetaDataBuilder.createBuilder((String)targetName, null);
        if (handlerMetaData instanceof HandlerMetaData) {
            builder.setBean(((HandlerMetaData)handlerMetaData).getClassName());
        } else if (handlerMetaData instanceof AsyncHandlerMetaData) {
            AsyncHandlerMetaData asyncHandlerMetaData = (AsyncHandlerMetaData)handlerMetaData;
            builder.setBean(AsyncHandler.class.getName());
            builder.addConstructorParameter(Integer.TYPE.getName(), (Object)asyncHandlerMetaData.getQueueLength());
            builder.addConstructorParameter(ThreadFactory.class.getName(), builder.createValue((Object)Executors.defaultThreadFactory()));
        } else if (handlerMetaData instanceof ConsoleHandlerMetaData) {
            ConsoleHandlerMetaData consoleHandlerMetaData = (ConsoleHandlerMetaData)handlerMetaData;
            builder.setBean(ConsoleHandler.class.getName());
            builder.addPropertyMetaData("target", (Object)targetMap.get((Object)consoleHandlerMetaData.getTarget()));
        } else if (handlerMetaData instanceof FileHandlerMetaData) {
            FileHandlerMetaData fileHandlerMetaData = (FileHandlerMetaData)handlerMetaData;
            if (handlerMetaData instanceof PeriodicRotatingFileHandlerMetaData) {
                PeriodicRotatingFileHandlerMetaData periodicRotatingFileHandlerMetaData = (PeriodicRotatingFileHandlerMetaData)handlerMetaData;
                builder.setBean(PeriodicRotatingFileHandler.class.getName());
                builder.addPropertyMetaData("suffix", periodicRotatingFileHandlerMetaData.getSuffix());
            } else if (handlerMetaData instanceof SizeRotatingFileHandlerMetaData) {
                SizeRotatingFileHandlerMetaData sizeRotatingFileHandlerMetaData = (SizeRotatingFileHandlerMetaData)handlerMetaData;
                builder.setBean(SizeRotatingFileHandler.class.getName());
                builder.addPropertyMetaData("maxBackupIndex", (Object)sizeRotatingFileHandlerMetaData.getMaxBackupIndex());
                String sizeString = sizeRotatingFileHandlerMetaData.getRotateSizeString();
                builder.addPropertyMetaData("rotateSize", (Object)LoggingMetaDataHelper.parseSizeString(sizeString));
            } else {
                builder.setBean(FileHandler.class.getName());
            }
            builder.addConstructorParameter(String.class.getName(), fileHandlerMetaData.getFileName());
            builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)fileHandlerMetaData.isAppend());
        } else if (handlerMetaData instanceof Log4jAppenderMetaData) {
            BeanMetaDataBuilder appenderBuilder;
            Log4jAppenderMetaData appenderMetaData = (Log4jAppenderMetaData)handlerMetaData;
            String log4jTargetName = targetName + ":log4j";
            propertyTarget = appenderBuilder = BeanMetaDataBuilder.createBuilder((String)log4jTargetName, null);
            builder.setBean(Log4jAppenderHandler.class.getName());
            builder.addConstructorParameter("org.apache.log4j.Appender", builder.createInject((Object)log4jTargetName));
            appenderBuilder.setBean(appenderMetaData.getClassName());
        } else if (handlerMetaData instanceof NullHandlerMetaData) {
            builder.setBean(NullHandler.class.getName());
        } else if (handlerMetaData instanceof RefMetaData) {
            return builder.createInject((Object)LoggingMetaDataHelper.getName(context, Kind.HANDLER, handlerMetaData.getName()));
        }
        builder.setStop("close");
        builder.setMode(ControllerMode.ON_DEMAND);
        builder.addPropertyMetaData("autoFlush", (Object)handlerMetaData.isAutoflush());
        String encoding = handlerMetaData.getEncoding();
        if (encoding != null) {
            builder.addPropertyMetaData("encoding", builder.createValue((Object)encoding));
        }
        if ((properties = handlerMetaData.getPropertyMetaDataList()) != null) {
            for (PropertyMetaData property : properties) {
                propertyTarget.addPropertyMetaData(property.getName(), property.getValue());
            }
        }
        if ((errorManager = handlerMetaData.getErrorManagerMetaData()) != null) {
            if (errorManager.isOnlyOnce()) {
                builder.addPropertyMetaData("errorManager", builder.createValue((Object)new OnlyOnceErrorManager()));
            } else {
                builder.addPropertyMetaData("errorManager", errorManager.getValueMetaData());
            }
        }
        if ((levelRef = handlerMetaData.getLevelMetaData()) != null) {
            builder.addPropertyMetaData("level", LoggingMetaDataHelper.getLevelInjectValue(context, levelRef.getName()));
        }
        if ((filter = handlerMetaData.getFilterMetaData()) != null) {
            builder.addPropertyMetaData("filter", LoggingMetaDataHelper.getValue(beanMetaDataList, context, filter));
        }
        if ((formatter = handlerMetaData.getFormatterMetaData()) != null) {
            builder.addPropertyMetaData("formatter", LoggingMetaDataHelper.getValue(beanMetaDataList, formatter, context));
        }
        if ((subHandlers = handlerMetaData.getSubHandlerMetaDataList()) != null) {
            List subHandlerValueList = builder.createArray(Handler[].class.getName(), Handler.class.getName());
            for (AbstractHandlerMetaData subHandler : subHandlers) {
                subHandlerValueList.add(LoggingMetaDataHelper.getValue(beanMetaDataList, subHandler, context));
            }
            ParameterMetaDataBuilder setHandlers = builder.addInstallWithParameters("setHandlers", null, null, ControllerState.CONFIGURED);
            setHandlers.addParameterMetaData("[Ljava.util.logging.Handler;", (ValueMetaData)subHandlerValueList);
        }
        BeanMetaData handlerBeanMetaData = builder.getBeanMetaData();
        beanMetaDataList.add(handlerBeanMetaData);
        if (builder != propertyTarget) {
            beanMetaDataList.add(propertyTarget.getBeanMetaData());
        }
        if ((loggers = handlerMetaData.getLoggerMetaDataList()) != null) {
            String installerName = LoggingMetaDataHelper.getInstallerName(context, "*");
            BeanMetaDataBuilder installerBuilder = BeanMetaDataBuilder.createBuilder((String)installerName, (String)HandlerInstallerHelper.class.getName());
            List targetList = installerBuilder.createList();
            for (AbstractLoggerRefMetaData loggerRef : loggers) {
                String refContext = loggerRef.getContext();
                String refName = loggerRef instanceof LoggerRefMetaData ? ((LoggerRefMetaData)loggerRef).getCategory() : "";
                targetList.add(LoggingMetaDataHelper.getLoggerInjectValue(refContext == null ? context : refContext, refName));
            }
            List handlerList = installerBuilder.createList();
            handlerList.add(handlerBeanMetaData);
            installerBuilder.addPropertyMetaData("handlerList", (ValueMetaData)handlerList);
            installerBuilder.addPropertyMetaData("targetList", (ValueMetaData)targetList);
            beanMetaDataList.add(installerBuilder.getBeanMetaData());
        }
        return handlerBeanMetaData;
    }

    private static long parseSizeString(String sizeString) {
        Matcher matcher = SIZE_PATTERN.matcher(sizeString);
        if (matcher.matches()) {
            long size = Long.parseLong(matcher.group(1));
            String multStr = matcher.group(2);
            int multChar = multStr.length() == 0 ? 98 : (int)Character.toLowerCase(multStr.charAt(0));
            switch (multChar) {
                case 98: {
                    break;
                }
                case 107: {
                    return size * 1024L;
                }
                case 109: {
                    return size * 1024L * 1024L;
                }
                case 103: {
                    return size * 1024L * 1024L * 1024L;
                }
                case 116: {
                    return size * 1024L * 1024L * 1024L * 1024L;
                }
            }
            throw new IllegalStateException();
        }
        throw new IllegalArgumentException("Invalid size string \"" + sizeString + "\"");
    }

    private static ValueMetaData getLevelInjectValue(String context, String name) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        AbstractValueFactoryMetaData avfmd = new AbstractValueFactoryMetaData((Object)LoggingMetaDataHelper.getContextName(context), "getLevelForName");
        ArrayList<AbstractParameterMetaData> parameterList = new ArrayList<AbstractParameterMetaData>(1);
        avfmd.setParameters(parameterList);
        parameterList.add(new AbstractParameterMetaData(String.class.getName(), name));
        return avfmd;
    }

    private static ValueMetaData getLoggerInjectValue(String context, String category) {
        if (context == null) {
            throw new NullPointerException("context is null");
        }
        if (category == null) {
            throw new NullPointerException("category is null");
        }
        AbstractValueFactoryMetaData avfmd = new AbstractValueFactoryMetaData((Object)LoggingMetaDataHelper.getContextName(context), "getLogger");
        ArrayList<AbstractParameterMetaData> parameterList = new ArrayList<AbstractParameterMetaData>(1);
        avfmd.setParameters(parameterList);
        parameterList.add(new AbstractParameterMetaData(String.class.getName(), category));
        return avfmd;
    }

    private static ValueMetaData getValue(List<BeanMetaData> beanMetaDataList, String context, FilterMetaData filterMetaData) {
        String name = filterMetaData.getName();
        String beanName = name == null ? LoggingMetaDataHelper.getAnonymousName(context, Kind.FILTER) : LoggingMetaDataHelper.getName(context, Kind.FILTER, name);
        Object value = filterMetaData.getValue();
        return LoggingMetaDataHelper.getFilterValue(beanMetaDataList, beanName, context, value);
    }

    private static ValueMetaData getFilterValue(List<BeanMetaData> beanMetaDataList, String beanName, String context, Object value) {
        if (value instanceof ValueMetaData) {
            return (ValueMetaData)value;
        }
        if (value instanceof RefMetaData) {
            return new AbstractInjectionValueMetaData((Object)((RefMetaData)value).getName());
        }
        if (value instanceof AbstractMultiFilterMetaData) {
            AbstractMultiFilterMetaData metaData = (AbstractMultiFilterMetaData)value;
            BeanMetaDataBuilder builder = metaData instanceof AllFilterMetaData ? BeanMetaDataBuilder.createBuilder((String)beanName, (String)AllFilter.class.getName()) : BeanMetaDataBuilder.createBuilder((String)beanName, (String)AnyFilter.class.getName());
            List filterList = builder.createArray();
            for (Object filterValue : metaData.getFilterMetaDataList()) {
                filterList.add(LoggingMetaDataHelper.getFilterValue(beanMetaDataList, LoggingMetaDataHelper.getAnonymousName(context, Kind.FILTER), context, filterValue));
            }
            builder.addConstructorParameter(Filter[].class.getName(), (ValueMetaData)filterList);
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof AcceptFilterMetaData) {
            return new AbstractValueMetaData((Object)AcceptAllFilter.getInstance());
        }
        if (value instanceof DenyFilterMetaData) {
            return new AbstractValueMetaData((Object)DenyAllFilter.getInstance());
        }
        if (value instanceof NotFilterMetaData) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)InvertFilter.class.getName());
            builder.addConstructorParameter(Filter.class.getName(), LoggingMetaDataHelper.getFilterValue(beanMetaDataList, LoggingMetaDataHelper.getAnonymousName(context, Kind.FILTER), context, ((NotFilterMetaData)value).getValue()));
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof MatchFilterMetaData) {
            MatchFilterMetaData metaData = (MatchFilterMetaData)value;
            String pattern = metaData.getPattern();
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)RegexFilter.class.getName());
            builder.addConstructorParameter(String.class.getName(), pattern);
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof ReplaceFilterMetaData) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)SubstituteFilter.class.getName());
            ReplaceFilterMetaData metaData = (ReplaceFilterMetaData)value;
            builder.addConstructorParameter(String.class.getName(), metaData.getPattern());
            builder.addConstructorParameter(String.class.getName(), metaData.getReplacement());
            builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isReplaceAll());
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof LevelFilterMetaData) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)LevelFilter.class.getName());
            LevelFilterMetaData metaData = (LevelFilterMetaData)value;
            builder.addConstructorParameter(Level.class.getName(), LoggingMetaDataHelper.getLevelInjectValue(context, metaData.getLevel()));
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof LevelRangeFilterMetaData) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)LevelRangeFilter.class.getName());
            LevelRangeFilterMetaData metaData = (LevelRangeFilterMetaData)value;
            builder.addConstructorParameter(Level.class.getName(), LoggingMetaDataHelper.getLevelInjectValue(context, metaData.getMinLevel()));
            builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isMinInclusive());
            builder.addConstructorParameter(Level.class.getName(), LoggingMetaDataHelper.getLevelInjectValue(context, metaData.getMaxLevel()));
            builder.addConstructorParameter(Boolean.TYPE.getName(), (Object)metaData.isMaxInclusive());
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        if (value instanceof LevelChangeFilterMetaData) {
            BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)beanName, (String)LevelChangingFilter.class.getName());
            LevelChangeFilterMetaData metaData = (LevelChangeFilterMetaData)value;
            builder.addConstructorParameter(Level.class.getName(), LoggingMetaDataHelper.getLevelInjectValue(context, metaData.getLevel()));
            BeanMetaData beanMetaData = builder.getBeanMetaData();
            beanMetaDataList.add(beanMetaData);
            return beanMetaData;
        }
        throw new IllegalStateException("Unexpected metadata type: " + value);
    }

    private static ValueMetaData getValue(List<BeanMetaData> beanMetaDataList, FormatterMetaData formatter, String context) {
        RefMetaData refMetaData = formatter.getFormatterRefMetaData();
        if (refMetaData != null) {
            return new AbstractInjectionValueMetaData((Object)refMetaData.getName());
        }
        ValueMetaData valueMetaData = formatter.getValueMetaData();
        if (valueMetaData != null) {
            return valueMetaData;
        }
        PatternFormatterMetaData metaData = formatter.getPatternFormatterMetaData();
        if (metaData == null) {
            return null;
        }
        BeanMetaDataBuilder builder = BeanMetaDataBuilder.createBuilder((String)LoggingMetaDataHelper.getAnonymousName(context, Kind.FORMATTER), (String)PatternFormatter.class.getName());
        builder.addConstructorParameter(String.class.getName(), metaData.getPattern());
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        beanMetaDataList.add(beanMetaData);
        return beanMetaData;
    }

    public static String getName(String context, Kind kind, String name) {
        StringBuilder b = new StringBuilder(64);
        b.append("Logging:");
        b.append((Object)kind);
        b.append(':');
        b.append(context);
        b.append(':');
        b.append(name);
        return b.toString();
    }

    public static String getAnonymousName(String context, Kind kind) {
        StringBuilder b = new StringBuilder(64);
        b.append("Logging:");
        b.append((Object)kind);
        b.append(':');
        b.append(context);
        b.append(':');
        b.append("Anonymous-");
        b.append(sequence.getAndIncrement());
        return b.toString();
    }

    public static String getInstallerName(String context, String category) {
        StringBuilder b = new StringBuilder(64);
        b.append("Logging:HANDLER_INSTALLER:");
        b.append(context);
        b.append(':');
        b.append(category);
        b.append(':');
        b.append(sequence.getAndIncrement());
        return b.toString();
    }

    public static String getContextName(String name) {
        StringBuilder b = new StringBuilder(64);
        b.append("Logging:CONTEXT:");
        b.append(name);
        return b.toString();
    }

    static {
        targetMap.put(ConsoleHandlerMetaData.Target.SYSTEM_ERR, ConsoleHandler.Target.SYSTEM_ERR);
        targetMap.put(ConsoleHandlerMetaData.Target.SYSTEM_OUT, ConsoleHandler.Target.SYSTEM_OUT);
        SIZE_PATTERN = Pattern.compile("(\\d+)([bBkKmMgGtT]?)");
    }

    public static enum Kind {
        FORMATTER,
        HANDLER,
        FILTER,
        LOGGER,
        REGISTRATION;

    }
}

