/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.metadata;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.jboss.marshalling.river.RiverProviderDescriptor;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.remote.RemoteProtocol;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.remoting3.spi.ConnectionProvider;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.jboss.remoting3.spi.NetworkServerProvider;
import org.jboss.remoting3.spi.ProtocolServiceType;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.Connector;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.SslTcpConnector;
import org.jboss.xnio.TcpConnector;
import org.jboss.xnio.channels.ConnectedStreamChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RemotingHelper {
    private RemotingHelper() {
    }

    public static ChannelListener<ConnectedStreamChannel<InetSocketAddress>> createServer(Endpoint endpoint, String protocol, OptionMap optionMap, ServerAuthenticationProvider authHandler) throws UnknownURISchemeException {
        return ((NetworkServerProvider)endpoint.getConnectionProviderInterface(protocol, NetworkServerProvider.class)).getServerListener(optionMap, authHandler);
    }

    public static Endpoint createEndpoint(String name, final TcpConnector tcpConnector, final SslTcpConnector sslConnector, Executor executor, OptionMap optionMap) throws IOException {
        Endpoint endpoint = Remoting.createEndpoint((String)name, (Executor)executor, (OptionMap)optionMap);
        endpoint.addProtocolService(ProtocolServiceType.MARSHALLER_PROVIDER_DESCRIPTOR, "river", (Object)new RiverProviderDescriptor());
        endpoint.addConnectionProvider("remote", new ConnectionProviderFactory(){

            public ConnectionProvider createInstance(ConnectionProviderContext context) {
                return RemoteProtocol.getRemoteConnectionProvider((ConnectionProviderContext)context, (Connector)tcpConnector);
            }
        });
        if (sslConnector != null) {
            endpoint.addConnectionProvider("remote+ssl", new ConnectionProviderFactory(){

                public ConnectionProvider createInstance(ConnectionProviderContext context) {
                    return RemoteProtocol.getRemoteConnectionProvider((ConnectionProviderContext)context, (Connector)sslConnector);
                }
            });
        }
        return endpoint;
    }
}

