/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml.wrapper;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.Utilities;
import org.ho.yaml.exception.PropertyAccessException;
import org.ho.yaml.wrapper.AbstractWrapper;
import org.ho.yaml.wrapper.MapWrapper;

public class DefaultBeanWrapper
extends AbstractWrapper
implements MapWrapper {
    public DefaultBeanWrapper(Class clazz) {
        super(clazz);
    }

    public boolean hasProperty(String string) {
        PropertyDescriptor propertyDescriptor = ReflectionUtil.getPropertyDescriptor(this.type, string);
        return this.config.isPropertyAccessibleForEncoding(propertyDescriptor);
    }

    public Object getProperty(String string) throws PropertyAccessException {
        Object object = this.getObject();
        return this.getProperty(object, string);
    }

    public Object getProperty(Object object, String string) {
        Object object2;
        try {
            object2 = ReflectionUtil.getPropertyDescriptor(this.type, string);
            if (this.config.isPropertyAccessibleForEncoding((PropertyDescriptor)object2)) {
                Method method = ((PropertyDescriptor)object2).getReadMethod();
                method.setAccessible(true);
                return method.invoke(object, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = this.type.getDeclaredField(string);
            if (this.config.isFieldAccessibleForEncoding((Field)object2)) {
                ((Field)object2).setAccessible(true);
                return ((Field)object2).get(object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new PropertyAccessException("Can't get " + string + " property on type " + this.type + ".");
    }

    public void setProperty(String string, Object object) throws PropertyAccessException {
        Object object2;
        try {
            object2 = ReflectionUtil.getPropertyDescriptor(this.type, string);
            if (this.config.isPropertyAccessibleForEncoding((PropertyDescriptor)object2)) {
                Method method = ((PropertyDescriptor)object2).getWriteMethod();
                method.setAccessible(true);
                method.invoke(this.getObject(), object);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = this.type.getDeclaredField(string);
            if (this.config.isFieldAccessibleForDecoding((Field)object2)) {
                ((Field)object2).setAccessible(true);
                ((Field)object2).set(this.getObject(), object);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public Class getPropertyType(String string) {
        if (ReflectionUtil.hasProperty(this.type, string)) {
            return ReflectionUtil.getPropertyDescriptor(this.type, string).getPropertyType();
        }
        try {
            Field field = this.type.getDeclaredField(string);
            if (ReflectionUtil.isMemberField(field)) {
                field.setAccessible(true);
                return field.getType();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public boolean containsKey(Object object) {
        return this.hasProperty((String)object);
    }

    public Object get(Object object) {
        return this.getProperty((String)object);
    }

    public Class getExpectedType(Object object) {
        return this.getPropertyType((String)object);
    }

    public Collection keys() {
        Object object = this.createPrototype();
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertyDescriptor propertyDescriptor : ReflectionUtil.getProperties(this.getType())) {
            if (!this.config.isPropertyAccessibleForEncoding(propertyDescriptor)) continue;
            try {
                if (Utilities.same(this.getProperty(this.getObject(), propertyDescriptor.getName()), this.getProperty(object, propertyDescriptor.getName()))) continue;
                hashSet.add(propertyDescriptor.getName());
            }
            catch (Exception exception) {}
        }
        for (Field field : this.getType().getDeclaredFields()) {
            if (!this.config.isFieldAccessibleForEncoding(field)) continue;
            field.setAccessible(true);
            try {
                if (Utilities.same(field.get(object), field.get(this.getObject()))) continue;
                hashSet.add(field.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.compareTo(string2);
            }
        });
        return arrayList;
    }

    public void put(Object object, Object object2) {
        this.setProperty((String)object, object2);
    }
}

