/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UniqueIdVendor;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.compiler.AbstractUIHandler;
import org.apache.myfaces.view.facelets.compiler.Instruction;
import org.apache.myfaces.view.facelets.compiler.UIInstructions;
import org.apache.myfaces.view.facelets.el.ELText;
import org.apache.myfaces.view.facelets.tag.jsf.ComponentSupport;
import org.apache.myfaces.view.facelets.util.FastWriter;

final class UIInstructionHandler
extends AbstractUIHandler {
    private final String alias;
    private final String id;
    private final ELText txt;
    private final Instruction[] instructions;
    private final int length;
    private final boolean literal;

    public UIInstructionHandler(String alias, String id, Instruction[] instructions, ELText txt) {
        this.alias = alias;
        this.id = id;
        this.instructions = instructions;
        this.txt = txt;
        this.length = txt.toString().length();
        boolean literal = true;
        int size = instructions.length;
        for (int i = 0; i < size; ++i) {
            Instruction ins = this.instructions[i];
            if (ins.isLiteral()) continue;
            literal = false;
            break;
        }
        this.literal = literal;
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (parent != null) {
            String id = ctx.generateUniqueId(this.id);
            Object c = null;
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            boolean componentFoundInserted = false;
            if (mctx.isRefreshingTransientBuild()) {
                c = ComponentSupport.findChildByTagId(parent, id);
            }
            boolean componentFound = false;
            if (c != null) {
                componentFound = true;
                ComponentSupport.markForDeletion(c);
            } else {
                Instruction[] applied;
                if (this.literal) {
                    applied = this.instructions;
                } else {
                    int size = this.instructions.length;
                    applied = new Instruction[size];
                    for (int i = 0; i < size; ++i) {
                        Instruction ins = this.instructions[i];
                        applied[i] = ins.apply(ctx.getExpressionFactory(), (ELContext)ctx);
                    }
                }
                c = new UIInstructions(this.txt, applied);
                UniqueIdVendor uniqueIdVendor = FaceletCompositionContext.getCurrentInstance(ctx).getUniqueIdVendorFromStack();
                if (uniqueIdVendor == null) {
                    uniqueIdVendor = ComponentSupport.getViewRoot(ctx, parent);
                }
                if (uniqueIdVendor != null) {
                    String uid = uniqueIdVendor.createUniqueId(ctx.getFacesContext(), id);
                    c.setId(uid);
                }
                c.getAttributes().put("org.apache.myfaces.view.facelets.MARK_ID", id);
            }
            boolean oldProcessingEvents = ctx.getFacesContext().isProcessingEvents();
            if (componentFound) {
                ComponentSupport.finalizeForDeletion(c);
                if (!componentFoundInserted) {
                    if (mctx.isRefreshingTransientBuild()) {
                        ctx.getFacesContext().setProcessingEvents(false);
                    }
                    parent.getChildren().remove(c);
                    if (mctx.isRefreshingTransientBuild()) {
                        ctx.getFacesContext().setProcessingEvents(oldProcessingEvents);
                    }
                }
            }
            if (!componentFoundInserted) {
                if (componentFound && mctx.isRefreshingTransientBuild()) {
                    ctx.getFacesContext().setProcessingEvents(false);
                }
                this.addComponent(ctx, parent, (UIComponent)c);
                if (componentFound && mctx.isRefreshingTransientBuild()) {
                    ctx.getFacesContext().setProcessingEvents(oldProcessingEvents);
                }
            }
        }
    }

    public String toString() {
        return this.txt.toString();
    }

    public String getText() {
        return this.txt.toString();
    }

    public String getText(FaceletContext ctx) {
        FastWriter writer = new FastWriter(this.length);
        try {
            this.txt.apply(ctx.getExpressionFactory(), (ELContext)ctx).write(writer, (ELContext)ctx);
        }
        catch (IOException e) {
            throw new ELException(this.alias + ": " + e.getMessage(), e.getCause());
        }
        return ((Object)writer).toString();
    }
}

