/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerComponent
extends MBeanResourceComponent<MBeanResourceComponent> {
    private static final Log log = LogFactory.getLog(CacheManagerComponent.class);
    protected ResourceContext<JMXComponent> context;
    private String cacheManagerPattern;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getEmsConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheManagerBean(conn);
            if (bean != null) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)"Cache manager {0} could be found and attributes where refreshed, so it's up.", new Object[]{bean});
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache manager could not be found, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext context) {
        this.context = context;
        this.cacheManagerPattern = "*:type=CacheManager,name=" + ObjectName.quote(context.getResourceKey()) + ",*";
    }

    public EmsConnection getEmsConnection() {
        return ((JMXComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Get values for these metrics: {0}", new Object[]{metrics});
        }
        EmsConnection conn = this.getEmsConnection();
        if (trace) {
            log.trace((Object)"Connection to ems server established: {0}", new Object[]{conn});
        }
        EmsBean bean = this.queryCacheManagerBean(conn);
        bean.refreshAttributes();
        if (trace) {
            log.trace((Object)"Querying returned bean: {0}", new Object[]{bean});
        }
        for (MeasurementScheduleRequest req : metrics) {
            DataType type = req.getDataType();
            if (type == DataType.MEASUREMENT) {
                String tmp = (String)bean.getAttribute(req.getName()).getValue();
                Double val = Double.valueOf(tmp);
                if (trace) {
                    log.trace((Object)"Metric ({0}) is measurement with value {1}", new Object[]{req.getName(), val});
                }
                MeasurementDataNumeric res = new MeasurementDataNumeric(req, val);
                report.addData(res);
                continue;
            }
            if (type != DataType.TRAIT) continue;
            String value = (String)bean.getAttribute(req.getName()).getValue();
            if (trace) {
                log.trace((Object)"Metric ({0}) is trait with value {1}", new Object[]{req.getName(), value});
            }
            MeasurementDataTrait res = new MeasurementDataTrait(req, value);
            report.addData(res);
        }
    }

    private EmsBean queryCacheManagerBean(EmsConnection conn) {
        ObjectNameQueryUtility queryUtility;
        List beans;
        String pattern = this.cacheManagerPattern;
        if (log.isTraceEnabled()) {
            log.trace((Object)"Pattern to query is {0}", new Object[]{pattern});
        }
        if ((beans = conn.queryBeans((queryUtility = new ObjectNameQueryUtility(pattern)).getTranslatedQuery())).size() > 1) {
            log.warn((Object)"More than one bean returned from applying {0} pattern: {1}", new Object[]{pattern, beans});
        }
        return (EmsBean)beans.get(0);
    }
}

