/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.virtual.assembly;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.virtual.PathRestriction;
import org.jboss.profileservice.spi.virtual.VirtualArtifactMetaData;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.profileservice.spi.virtual.assembly.VirtualDeploymentAssemblyContext;
import org.jboss.profileservice.virtual.assembly.AbstractVirtualAssemblyContext;
import org.jboss.profileservice.virtual.assembly.AbstractVirtualDeploymentAssembly;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileAssembly;
import org.jboss.vfs.VirtualFileFilter;

public class BasicVirtualAssemblyContext
extends AbstractVirtualAssemblyContext
implements VirtualDeploymentAssemblyContext,
Closeable {
    public static final String META_INF = "META-INF";
    private final VirtualFile root;
    private final VirtualFileAssembly fileAssembly;
    private final AbstractVirtualDeploymentAssembly assembly;
    private final Closeable assemblyHandle;

    public BasicVirtualAssemblyContext(VirtualFileAssembly fileAssembly, VirtualFile vf, Closeable closeable, AbstractVirtualDeploymentAssembly assembly) {
        this.root = vf;
        this.fileAssembly = fileAssembly;
        this.assembly = assembly;
        this.assemblyHandle = closeable;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public VirtualFileAssembly getAssemblyRoot() {
        return this.fileAssembly;
    }

    public VirtualDeploymentAssemblyContext addChild(VirtualDeploymentMetaData child) throws IOException {
        if (child == null) {
            throw new IllegalArgumentException("null virtual deployment");
        }
        if (child.getName() == null) {
            throw new IllegalArgumentException("null virtual deployment name");
        }
        VirtualDeploymentAssemblyContext ctx = this.assembly.createChildAssemblyContext(child, this.getRoot());
        this.addChild(ctx);
        return ctx;
    }

    public void addArtifact(VirtualArtifactMetaData artifactId) throws IOException {
        if (artifactId == null) {
            throw new IllegalArgumentException("null artifact id");
        }
        VirtualFile resolved = this.resolveRealArtifact(artifactId);
        String targetPath = artifactId.getTargetPath();
        targetPath = targetPath != null ? targetPath.trim() : "";
        this.addArtifact(targetPath, resolved, new RecurseFilter(resolved, artifactId), artifactId.getArtifactType());
    }

    void addArtifact(String targetPath, VirtualFile location, VirtualFileFilter filter, VirtualArtifactMetaData.ArtifactType type) throws IOException {
        if (location.isFile()) {
            String name = targetPath.isEmpty() ? location.getName() : targetPath + "/" + location.getName();
            if (type == VirtualArtifactMetaData.ArtifactType.METADATA_LOCATION) {
                this.addMetaDataLocation(targetPath);
            } else if (type == VirtualArtifactMetaData.ArtifactType.CLASSPATH_LOCATION) {
                this.addClassPathLocation(name);
            }
            this.getAssemblyRoot().add(name, location);
        } else {
            for (VirtualFile child : location.getChildren()) {
                if (!filter.accepts(child)) continue;
                this.addArtifact(targetPath, child, filter, type);
            }
        }
    }

    protected VirtualFile resolveRealArtifact(VirtualArtifactMetaData path) throws IOException {
        return this.assembly.getOriginalVirtualFile((ArtifactId)path);
    }

    @Override
    public void close() {
        super.close();
        VFSUtils.safeClose((Closeable)this.assemblyHandle);
    }

    protected static class RecurseFilter
    implements VirtualFileFilter {
        private final VirtualFile parent;
        private final VirtualArtifactMetaData artifact;

        public RecurseFilter(VirtualFile parent, VirtualArtifactMetaData artifactId) {
            this.parent = parent;
            this.artifact = artifactId;
        }

        public boolean accepts(VirtualFile file) {
            boolean matched = false;
            String path = file.getPathNameRelativeTo(this.parent);
            if (this.getIncludes() == null || this.getIncludes().isEmpty()) {
                matched = true;
            } else {
                for (PathRestriction include : this.getIncludes()) {
                    if (!include.matches(path)) continue;
                    matched = true;
                    break;
                }
            }
            if (!matched) {
                return false;
            }
            if (this.getExcludes() != null && !this.getExcludes().isEmpty()) {
                for (PathRestriction exclude : this.getExcludes()) {
                    if (!exclude.matches(path)) continue;
                    return false;
                }
            }
            return true;
        }

        Collection<PathRestriction> getIncludes() {
            return this.artifact.getIncludes();
        }

        Collection<PathRestriction> getExcludes() {
            return this.artifact.getExcludes();
        }
    }
}

