/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.version.helpers;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.jboss.metatype.api.annotations.CompositeKey;
import org.jboss.metatype.api.annotations.CompositeValue;
import org.jboss.profileservice.version.Version;
import org.jboss.profileservice.version.VersionRange;

public class VersionRangeSupport
implements Serializable {
    private static final long serialVersionUID = -8513078180234534850L;
    private VersionRange versionRange = VersionRange.ALL_VERSIONS;

    public VersionRangeSupport() {
    }

    public VersionRangeSupport(VersionRange versionRange) {
        if (versionRange == null) {
            versionRange = VersionRange.ALL_VERSIONS;
        }
        this.versionRange = versionRange;
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    @CompositeValue(ignore=true)
    @XmlTransient
    public void setVersionRange(VersionRange versionRange) {
        if (versionRange == null) {
            versionRange = VersionRange.ALL_VERSIONS;
        }
        this.versionRange = versionRange;
    }

    public Object getFrom() {
        return this.versionRange.getLow();
    }

    @CompositeValue(ignore=true)
    @XmlTransient
    public void setFrom(Object fromVersion) {
        this.versionRange = new VersionRange(fromVersion, this.versionRange.isLowInclusive(), this.versionRange.getHigh(), this.versionRange.isHighInclusive());
    }

    public Version getFromVersion() {
        Object from = this.getFrom();
        if (from == null) {
            return null;
        }
        if (from instanceof Version) {
            return (Version)from;
        }
        if (from instanceof String) {
            return Version.parseVersion((String)from);
        }
        throw new IllegalStateException(from + " is not an instance of version");
    }

    @CompositeKey
    @CompositeValue(name="from")
    @XmlAttribute(name="from")
    public void setFromVersion(Version fromVersion) {
        this.setFrom(fromVersion);
    }

    public boolean isFromVersionInclusive() {
        return this.versionRange.isLowInclusive();
    }

    @CompositeKey
    @XmlAttribute(name="from-inclusive")
    public void setFromVersionInclusive(boolean fromVersionInclusive) {
        this.versionRange = new VersionRange(this.versionRange.getLow(), fromVersionInclusive, this.versionRange.getHigh(), this.versionRange.isHighInclusive());
    }

    public Object getTo() {
        return this.versionRange.getHigh();
    }

    @CompositeValue(ignore=true)
    @XmlTransient
    public void setTo(Object toVersion) {
        this.versionRange = new VersionRange(this.versionRange.getLow(), this.versionRange.isLowInclusive(), toVersion, this.versionRange.isHighInclusive());
    }

    public Version getToVersion() {
        Object to = this.getTo();
        if (to == null) {
            return null;
        }
        if (to instanceof Version) {
            return (Version)to;
        }
        if (to instanceof String) {
            return Version.parseVersion((String)to);
        }
        throw new IllegalStateException(to + " is not an instance of version");
    }

    @CompositeKey
    @CompositeValue(name="to")
    @XmlAttribute(name="to")
    public void setToVersion(Version toVersion) {
        this.setTo(toVersion);
    }

    public boolean isToVersionInclusive() {
        return this.versionRange.isHighInclusive();
    }

    @CompositeKey
    @XmlAttribute(name="to-inclusive")
    public void setToVersionInclusive(boolean toVersionInclusive) {
        this.versionRange = new VersionRange(this.versionRange.getLow(), this.versionRange.isLowInclusive(), this.versionRange.getHigh(), toVersionInclusive);
    }

    @CompositeValue(ignore=true)
    @XmlAttribute(name="version")
    public void setVersion(Version version) {
        this.versionRange = new VersionRange(version, true, version, true);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VersionRangeSupport)) {
            return false;
        }
        VersionRangeSupport other = (VersionRangeSupport)obj;
        return this.getVersionRange().equals(other.getVersionRange());
    }

    public int hashCode() {
        return this.getVersionRange().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getVersionRange();
    }
}

