/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactTransformer;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class CopyStreamArtifactTransformer
implements ArtifactTransformer<ArtifactId> {
    private static final CopyStreamArtifactTransformer INSTANCE = new CopyStreamArtifactTransformer();

    public static <T extends ArtifactId> ArtifactTransformer<T> getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(ArtifactId artifactId, InputStream is, VirtualFile target) throws IOException {
        File file = target.getPhysicalFile();
        FileOutputStream os = new FileOutputStream(file);
        try {
            VFSUtils.copyStream((InputStream)is, (OutputStream)os);
        }
        finally {
            VFSUtils.safeClose((Closeable)os);
        }
    }
}

