/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.repository.artifact;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.profileservice.repository.artifact.BasicRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryConfiguration;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepositoryId;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractArtifactRepository<T extends ArtifactId>
implements ArtifactRepository<T> {
    private ArtifactRepositoryId identifier;
    private final ArtifactRepositoryConfiguration<T> configuration;
    private final VirtualFile repositoryRoot;
    private final URI repositoryURI;

    public AbstractArtifactRepository(ArtifactRepositoryId identifier, URI root) throws IOException {
        if (identifier == null) {
            throw new IllegalArgumentException("null identifier");
        }
        if (root == null) {
            throw new IllegalArgumentException("null repository root.");
        }
        this.repositoryRoot = VFS.getChild((URI)root);
        this.repositoryURI = root;
        this.identifier = identifier;
        this.configuration = new BasicRepositoryConfiguration();
    }

    public AbstractArtifactRepository(ArtifactRepositoryId identifier, VirtualFile root) throws IOException, URISyntaxException {
        if (identifier == null) {
            throw new IllegalArgumentException("null identifier");
        }
        if (root == null) {
            throw new IllegalArgumentException("null repository root.");
        }
        this.repositoryRoot = root;
        this.repositoryURI = root.toURI();
        this.identifier = identifier;
        this.configuration = new BasicRepositoryConfiguration();
    }

    public URI getRepositoryURI() {
        return this.repositoryURI;
    }

    public ArtifactRepositoryId getIdentifier() {
        return this.identifier;
    }

    public ArtifactRepositoryConfiguration<T> getConfiguration() {
        return this.configuration;
    }

    protected VirtualFile getRepositoryRoot() {
        return this.repositoryRoot;
    }

    public boolean isMutable() {
        return this.getConfiguration().isMutable();
    }
}

