/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.metadata.helpers;

import javax.xml.bind.annotation.XmlAttribute;
import org.jboss.profileservice.spi.dependency.DependencyMode;
import org.jboss.profileservice.spi.dependency.ProfileRequirement;
import org.jboss.profileservice.version.VersionRange;
import org.jboss.profileservice.version.helpers.NameAndVersionRangeSupport;

public class AbstractProfileRequirement
extends NameAndVersionRangeSupport
implements ProfileRequirement {
    private static final long serialVersionUID = -9013971913225421465L;
    private DependencyMode mode = DependencyMode.getDefault();

    public AbstractProfileRequirement() {
    }

    public AbstractProfileRequirement(String name) {
        super(name);
    }

    public AbstractProfileRequirement(String name, VersionRange versionRange) {
        super(name, versionRange);
    }

    @XmlAttribute(name="mode")
    public DependencyMode getDependencyMode() {
        return this.mode;
    }

    protected void setDependencyMode(DependencyMode mode) {
        this.mode = mode;
    }

    public boolean isOptional() {
        return this.mode == DependencyMode.OPTIONAL;
    }

    @XmlAttribute(name="optional")
    public void setOptional(boolean optional) {
        if (optional) {
            this.mode = DependencyMode.OPTIONAL;
        }
    }

    public boolean isConsistent(ProfileRequirement other) {
        return this.isConsistent(other, null);
    }

    protected boolean isConsistent(ProfileRequirement other, Class<? extends ProfileRequirement> requirementType) {
        String otherName;
        if (other == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        if (requirementType == null) {
            requirementType = this.getClass();
        }
        if (!requirementType.isInstance(other)) {
            return true;
        }
        AbstractProfileRequirement otherRequirement = (AbstractProfileRequirement)other;
        String name = this.getName();
        if (!name.equals(otherName = otherRequirement.getName())) {
            return true;
        }
        VersionRange range = this.getVersionRange();
        VersionRange otherRange = otherRequirement.getVersionRange();
        return range.isConsistent(otherRange);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof AbstractProfileRequirement)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        AbstractProfileRequirement other = (AbstractProfileRequirement)obj;
        return this.isOptional() == other.isOptional();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("{");
        this.toString(buffer);
        buffer.append("}");
        return buffer.toString();
    }

    protected void toString(StringBuffer buffer) {
        buffer.append(this.getName());
        buffer.append(" ").append(this.getVersionRange());
        if (this.isOptional()) {
            buffer.append(" OPTIONAL");
        }
    }
}

