/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile.bootstrap;

import java.net.URL;
import org.jboss.beans.metadata.plugins.AbstractClassLoaderMetaData;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.spi.ClassLoaderMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.vfs.metadata.VFSClassLoaderFactory;
import org.jboss.kernel.plugins.deployment.AbstractKernelDeployment;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.profileservice.deployment.DeploymentBuilder;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class KernelDeploymentBuilder
implements DeploymentBuilder<KernelDeployment> {
    private static final String ATTACHMENT_NAME = ClassLoadingMetaData.class.getName();
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();

    @Override
    public KernelDeployment createDeployment(ProfileKey key, ProfileDeployment profileDeployment) throws Exception {
        URL url = profileDeployment.getRoot().toURL();
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(url.toString(), resolver);
        if (deployment == null) {
            throw new RuntimeException("The xml " + url + " is not well formed!");
        }
        deployment.setName(profileDeployment.getName());
        if (profileDeployment.getPredeterminedAttachments().hasAttachment(ATTACHMENT_NAME) && deployment instanceof AbstractKernelDeployment) {
            this.processClassloadingMetaData((AbstractKernelDeployment)AbstractKernelDeployment.class.cast(deployment), profileDeployment);
        }
        return deployment;
    }

    protected void processClassloadingMetaData(AbstractKernelDeployment deployment, ProfileDeployment profileDeployment) {
        VirtualDeploymentMetaData deploymentMetaData = profileDeployment.getDeploymentInfo().getMetaData();
        VFSClassLoaderFactory clmd = (VFSClassLoaderFactory)profileDeployment.getPredeterminedAttachments().getAttachment(ATTACHMENT_NAME, VFSClassLoaderFactory.class);
        String virtualDeploymentName = deploymentMetaData.getName() + ":" + clmd.getVersion().toString();
        AbstractClassLoaderMetaData classLoader = new AbstractClassLoaderMetaData((ValueMetaData)new AbstractInjectionValueMetaData((Object)virtualDeploymentName));
        deployment.getBeanFactories().add(clmd);
        deployment.setClassLoader((ClassLoaderMetaData)classLoader);
    }
}

