/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.jboss.profileservice.profile.metadata.BasicProfileDeploymentMetaData;
import org.jboss.profileservice.repository.artifact.file.FileArtifact;
import org.jboss.profileservice.repository.artifact.file.FileArtifactId;
import org.jboss.profileservice.spi.NoSuchDeploymentException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.VirtualDeploymentRepository;
import org.jboss.profileservice.spi.repository.artifact.Artifact;
import org.jboss.profileservice.spi.repository.artifact.ArtifactFilter;
import org.jboss.profileservice.spi.repository.artifact.ArtifactId;
import org.jboss.profileservice.spi.repository.artifact.ArtifactRepository;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;

public abstract class AbstractScanningProfile
implements Profile,
ArtifactFilter<FileArtifactId> {
    private final ProfileKey key;
    private final VirtualDeploymentRepository deploymentRepository;
    private ArtifactRepository<FileArtifactId> artifactRepository;
    private Map<String, ProfileDeployment> deployments = new ConcurrentHashMap<String, ProfileDeployment>();
    private Map<String, String> repositoryNames = new HashMap<String, String>();
    private volatile long lastModified;

    public AbstractScanningProfile(ProfileKey key, VirtualDeploymentRepository deploymentRepository) {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        if (deploymentRepository == null) {
            throw new IllegalArgumentException("null virtual profile repository");
        }
        this.key = key;
        this.deploymentRepository = deploymentRepository;
    }

    protected abstract Logger getLog();

    public void create() throws IllegalStateException {
        this.artifactRepository = this.getDeploymentRepository().resolveArtifactRepository((ArtifactId)FileArtifactId.EMPTY_ARTIFACT);
        if (this.artifactRepository == null) {
            throw new IllegalStateException("failed to resolve artifact repository");
        }
    }

    public void start() throws IOException {
        this.scanRepository();
        this.updateLastModified();
    }

    public void stop() {
        for (ProfileDeployment deployment : this.deployments.values()) {
            try {
                deployment.cleanup();
            }
            catch (Exception e) {
                this.getLog().debug((Object)("failed to cleanup deployment " + deployment));
            }
        }
        this.deployments.clear();
        this.repositoryNames.clear();
    }

    public ProfileKey getKey() {
        return this.key;
    }

    public boolean hasDeployment(String name) {
        return this.resolveDeployment(name) != null;
    }

    public ProfileDeployment getDeployment(String name) throws NoSuchDeploymentException {
        ProfileDeployment deployment = this.resolveDeployment(name);
        if (deployment == null) {
            throw new NoSuchDeploymentException(name);
        }
        return deployment;
    }

    public Set<String> getDeploymentNames() {
        return this.deployments.keySet();
    }

    public Collection<ProfileDeployment> getDeployments() {
        return this.deployments.values();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    protected Collection<ProfileDeployment> scanRepository() throws IOException {
        Collection<Artifact<FileArtifactId>> artifacts = this.getArtifacts();
        if (artifacts != null && !artifacts.isEmpty()) {
            ArrayList<ProfileDeployment> deployments = new ArrayList<ProfileDeployment>();
            for (Artifact<FileArtifactId> artifact : artifacts) {
                FileArtifactId artifactId = (FileArtifactId)((Object)artifact.getIdentifier());
                ProfileDeployment deployment = this.createDeployment(artifactId);
                this.internalAddDeployment(deployment, artifactId);
                deployments.add(deployment);
            }
            return deployments;
        }
        return Collections.emptySet();
    }

    protected Collection<Artifact<FileArtifactId>> getArtifacts() {
        return this.getArtifactRepository().getArtifacts((ArtifactFilter)this);
    }

    public boolean accepts(Artifact<FileArtifactId> artifact) {
        FileArtifactId id = (FileArtifactId)((Object)artifact.getIdentifier());
        boolean exists = this.repositoryNames.containsKey(id.getPath());
        if (exists) {
            return false;
        }
        if (artifact instanceof FileArtifact) {
            if (((FileArtifact)artifact).isFile()) {
                return true;
            }
            return id.getPath().contains(".");
        }
        return false;
    }

    public boolean recurse(Artifact<FileArtifactId> artifact) {
        if (artifact instanceof FileArtifact && !((FileArtifact)artifact).isFile()) {
            FileArtifactId id = (FileArtifactId)((Object)artifact.getIdentifier());
            String path = id.getPath();
            return !path.contains(".");
        }
        return false;
    }

    protected ProfileDeployment resolveDeployment(String name) {
        ProfileDeployment deployment = this.deployments.get(name);
        if (deployment == null) {
            if (this.repositoryNames.containsKey(name)) {
                return this.deployments.get(this.repositoryNames.get(name));
            }
            for (ProfileDeployment d : this.getDeployments()) {
                if (!d.getSimpleName().equals(name)) continue;
                deployment = d;
                break;
            }
        }
        return deployment;
    }

    protected void internalAddDeployment(ProfileDeployment deployment, FileArtifactId artifactId) {
        this.deployments.put(deployment.getName(), deployment);
        this.repositoryNames.put(artifactId.getPath(), deployment.getName());
    }

    protected ProfileDeployment internalRemoveDeployment(String name) throws NoSuchDeploymentException {
        return this.internalRemoveDeployment(name, true);
    }

    protected ProfileDeployment internalRemoveDeployment(String name, boolean cleanup) throws NoSuchDeploymentException {
        ProfileDeployment deployment = this.getDeployment(name);
        FileArtifactId artifactId = this.getArtifactMetaData(deployment);
        this.deployments.remove(deployment.getName());
        this.repositoryNames.remove(artifactId.getPath());
        if (cleanup) {
            try {
                deployment.cleanup();
            }
            catch (Exception e) {
                this.getLog().debug((Object)("failed to cleanup deployment " + deployment));
            }
        }
        return deployment;
    }

    protected ProfileDeployment createDeployment(FileArtifactId artifactId) throws IOException {
        return this.createDeployment((VirtualDeploymentMetaData)new BasicProfileDeploymentMetaData(artifactId.getPath()));
    }

    protected ProfileDeployment createDeployment(VirtualDeploymentMetaData virtual) throws IOException {
        return this.getDeploymentRepository().createDeployment(virtual);
    }

    protected FileArtifactId getArtifactMetaData(ProfileDeployment deployment) {
        ArtifactId artifactId = deployment.getDeploymentInfo().getMetaData().getArtifact();
        if (artifactId == null || !(artifactId instanceof FileArtifactId)) {
            throw new IllegalStateException("failed to get file artifact id " + artifactId);
        }
        return (FileArtifactId)FileArtifactId.class.cast(artifactId);
    }

    protected ArtifactRepository<FileArtifactId> getArtifactRepository() {
        if (this.artifactRepository == null) {
            throw new IllegalStateException("null artifact repository");
        }
        return this.artifactRepository;
    }

    public VirtualDeploymentRepository getDeploymentRepository() {
        return this.deploymentRepository;
    }

    protected void updateLastModified() {
        this.lastModified = System.currentTimeMillis();
    }
}

