/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.deployment;

import java.io.Closeable;
import org.jboss.profileservice.deployment.AbstractDeploymentInfo;
import org.jboss.profileservice.deployment.DefaultAttachments;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.deployment.DeploymentAttachments;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.virtual.VirtualDeploymentMetaData;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public abstract class AbstractProfileDeployment
implements ProfileDeployment {
    private static final long serialVersionUID = 1536294883676418931L;
    private final ProfileDeploymentInfo info;
    private VirtualFile root;
    private DeploymentAttachments attachments = new DefaultAttachments();
    private transient DeploymentAttachments transientAttachments = new DefaultAttachments();

    protected AbstractProfileDeployment(String name, VirtualDeploymentMetaData deploymentMetaData) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        this.info = new AbstractDeploymentInfo(name, deploymentMetaData);
    }

    protected static final String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        try {
            return root.asFileURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public String getName() {
        return this.info.getName();
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public String getSimpleName() {
        if (this.root != null) {
            return this.getRoot().getName();
        }
        return this.getName();
    }

    protected void setRoot(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("null root");
        }
        this.root = root;
    }

    public ProfileDeploymentInfo getDeploymentInfo() {
        return this.info;
    }

    public DeploymentAttachments getPredeterminedAttachments() {
        return this.attachments;
    }

    public DeploymentAttachments getTransientAttachments() {
        return this.transientAttachments;
    }

    public void cleanup() throws Exception {
        this.cleanup(this.getPredeterminedAttachments());
        this.cleanup(this.getTransientAttachments());
    }

    protected void cleanup(DeploymentAttachments attachments) {
        for (Object o : attachments.getAttachments().values()) {
            if (!(o instanceof Closeable)) continue;
            VFSUtils.safeClose((Closeable)((Closeable)Closeable.class.cast(o)));
        }
    }
}

