/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import java.util.Collection;
import java.util.HashSet;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.kernel.plugins.dependency.InstallsAwareAction;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.metadata.ProfileConfigurationExt;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentFlag;
import org.jboss.profileservice.spi.deployment.ProfileDeploymentInfo;
import org.jboss.profileservice.spi.managed.ManagedProfileDeployer;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class ProfileDeployAction
extends InstallsAwareAction {
    public static final ControllerState DEPLOY_STATE = ControllerState.newState((String)"Deploy");
    private static final Logger log = Logger.getLogger(ProfileDeployAction.class);

    protected ControllerState getState() {
        return DEPLOY_STATE;
    }

    protected boolean validateContext(ControllerContext context) {
        return context instanceof ProfileControllerContext;
    }

    protected ProfileControllerContext contextCast(ControllerContext context) {
        return (ProfileControllerContext)((Object)ProfileControllerContext.class.cast(context));
    }

    protected void installActionInternal(KernelControllerContext ctx) throws Throwable {
        super.installActionInternal(ctx);
        ProfileControllerContext context = (ProfileControllerContext)((Object)ProfileControllerContext.class.cast(ctx));
        Profile profile = context.getProfile();
        if (profile == null) {
            throw new NoSuchProfileException("null profile " + context.getProfileKey());
        }
        if (profile.getDeployments() != null && !profile.getDeployments().isEmpty()) {
            ManagedProfileDeployer deployer = context.getManagedDeployer();
            if (deployer == null) {
                throw new IllegalStateException("null deployer for profile " + profile.getKey());
            }
            boolean isCheckComplete = this.isCheckComplete(context.getProfileMetaData());
            this.deploy(profile, deployer, isCheckComplete);
        }
    }

    protected void uninstallActionInternal(KernelControllerContext ctx) {
        ProfileControllerContext context = (ProfileControllerContext)((Object)ProfileControllerContext.class.cast(ctx));
        Profile profile = context.getProfile();
        if (profile.getDeployments() != null && !profile.getDeployments().isEmpty()) {
            ManagedProfileDeployer deployer = context.getManagedDeployer();
            if (deployer == null) {
                throw new IllegalStateException("null deployer for profile " + profile.getKey());
            }
            this.undeploy(profile, deployer);
        }
        super.uninstallActionInternal(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(Profile profile, ManagedProfileDeployer deployer, boolean isCheckComplete) throws Exception {
        long start = System.currentTimeMillis();
        try {
            Collection deployments = profile.getDeployments();
            if (deployments != null && !deployments.isEmpty()) {
                HashSet<String> deploymentNames = new HashSet<String>();
                for (ProfileDeployment deployment : profile.getDeployments()) {
                    try {
                        deployer.addDeployment(deployment);
                        deploymentNames.add(deployment.getName());
                        deployment.getDeploymentInfo().setFlag(ProfileDeploymentFlag.DEPLOYED);
                    }
                    catch (Exception e) {
                        if (isCheckComplete) {
                            throw e;
                        }
                        log.error((Object)("Failed to add deployment: " + deployment), (Throwable)e);
                    }
                }
                deployer.process();
                if (isCheckComplete) {
                    deployer.checkComplete(deploymentNames.toArray(new String[deploymentNames.size()]));
                }
            }
        }
        finally {
            if (log.isTraceEnabled()) {
                log.trace((Object)("deploying profile (" + profile.getKey().getName() + ") took: " + (System.currentTimeMillis() - start) + "ms"));
            }
        }
    }

    protected void undeploy(Profile profile, ManagedProfileDeployer deployer) {
        Collection deployments = profile.getDeployments();
        if (deployments != null && !deployments.isEmpty()) {
            for (ProfileDeployment deployment : profile.getDeployments()) {
                ProfileDeploymentInfo info = deployment.getDeploymentInfo();
                if (!info.isDeployed()) continue;
                try {
                    deployer.removeDeployment(deployment);
                }
                catch (Throwable t) {
                    log.warn((Object)("failed to remove deployment: " + deployment), t);
                }
                deployment.getDeploymentInfo().clearFlag(ProfileDeploymentFlag.DEPLOYED);
            }
            deployer.process();
        }
    }

    boolean isCheckComplete(ProfileMetaData metaData) {
        if (metaData instanceof ProfileConfigurationExt) {
            return ((ProfileConfigurationExt)ProfileConfigurationExt.class.cast(metaData)).isCheckComplete();
        }
        return false;
    }
}

