/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.dependency;

import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.ControllerStateModel;
import org.jboss.profileservice.dependency.ProfileActivationService;
import org.jboss.profileservice.dependency.ProfileControllerContext;
import org.jboss.profileservice.dependency.ProfileValidationUtil;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.activation.ProfileActivation;
import org.jboss.profileservice.spi.activation.ProfileActivationConfiguration;
import org.jboss.profileservice.spi.activation.ProfileActivator;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

class ProfileActivationWrapper
implements ProfileActivation {
    private final BasicProfileActivation activation;
    private final ProfileActivationService activationService;

    public ProfileActivationWrapper(ProfileControllerContext context) {
        this.activation = new BasicProfileActivation(context);
        this.activationService = context.getActivationService();
    }

    public ProfileKey getKey() {
        return this.activation.getKey();
    }

    public ProfileMetaData getProfileMetaData() {
        return this.activation.getProfileMetaData();
    }

    public void start() throws Exception {
        if (this.activation.isStarted()) {
            return;
        }
        this.activation.describe();
        ProfileActivator activator = this.resolveActivator(this.getActivationConfiguration());
        if (activator != null) {
            activator.activate((ProfileActivation)this.activation);
            return;
        }
        this.activation.start();
    }

    public void stop() {
        ProfileActivator activator = this.resolveActivator(this.getActivationConfiguration());
        if (activator != null) {
            activator.deactivate((ProfileActivation)this.activation);
            return;
        }
        this.activation.stop();
    }

    public boolean isResolved() {
        return this.activation.isResolved();
    }

    public boolean isStarted() {
        return this.activation.isStarted();
    }

    public void validate() throws Exception {
        this.activation.validate();
    }

    ProfileActivator resolveActivator(ProfileActivationConfiguration configuration) {
        if (configuration != null && configuration.getProfileActivatorRef() != null) {
            return this.activationService.getProfileActivator(configuration.getProfileActivatorRef());
        }
        return null;
    }

    ProfileActivationConfiguration getActivationConfiguration() {
        return this.activation.getActivationConfiguration();
    }

    ProfileControllerContext getContext() {
        return this.activation.getContext();
    }

    public String toString() {
        return this.getContext().toString();
    }

    static class BasicProfileActivation
    implements ProfileActivation {
        private final ProfileControllerContext context;

        public BasicProfileActivation(ProfileControllerContext context) {
            this.context = context;
        }

        ProfileControllerContext getContext() {
            return this.context;
        }

        public ProfileKey getKey() {
            return this.context.getProfileKey();
        }

        public ProfileMetaData getProfileMetaData() {
            return this.context.getProfileMetaData();
        }

        public boolean isResolved() {
            if (this.isBeforeState(ControllerState.DESCRIBED)) {
                return false;
            }
            return this.context.getDependencyInfo().resolveDependencies(this.getController(), ControllerState.DESCRIBED);
        }

        public boolean isStarted() {
            return !this.isBeforeState(ControllerState.INSTALLED);
        }

        public void start() throws Exception {
            try {
                this.getController().change((ControllerContext)this.context, ControllerState.INSTALLED);
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public void stop() {
            if (this.isBeforeState(ControllerState.DESCRIBED)) {
                return;
            }
            try {
                this.getController().change((ControllerContext)this.context, ControllerState.DESCRIBED);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public void validate() throws Exception {
            ProfileValidationUtil.validate(this.context);
        }

        void describe() throws Exception {
            if (this.isBeforeState(ControllerState.DESCRIBED)) {
                try {
                    this.getController().change((ControllerContext)this.context, ControllerState.DESCRIBED);
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        }

        boolean isBeforeState(ControllerState state) {
            Controller controller = this.context.getController();
            ControllerStateModel model = controller.getStates();
            return model.isBeforeState(this.context.getState(), state);
        }

        Controller getController() {
            return this.context.getController();
        }

        ProfileActivationConfiguration getActivationConfiguration() {
            return this.context.getDependencyContext().getActivationConfiguration();
        }
    }
}

