/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice;

import java.util.Collection;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.dependency.ProfileActivationService;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.profileservice.spi.metadata.ProfileMetaData;

public class AbstractProfileService
implements ProfileService {
    private ManagementView mgtView;
    private DeploymentManager deploymentMgr;
    private final ProfileActivationService activationService;

    public AbstractProfileService(ProfileActivationService activationService) {
        if (activationService == null) {
            throw new IllegalArgumentException("null activation service");
        }
        this.activationService = activationService;
    }

    public DeploymentManager getDeploymentManager() {
        return this.deploymentMgr;
    }

    public void setDeploymentManager(DeploymentManager deploymentMgr) {
        this.deploymentMgr = deploymentMgr;
    }

    public ManagementView getViewManager() {
        return this.mgtView;
    }

    public void setViewManager(ManagementView mgtView) {
        this.mgtView = mgtView;
    }

    public Collection<ProfileKey> getProfileKeys() {
        return this.activationService.getRegisteredKeys();
    }

    public Collection<ProfileKey> getActiveProfileKeys() {
        return this.activationService.getInstalledKeys();
    }

    public ProfileKey registerProfile(ProfileMetaData metaData) throws Exception {
        return this.registerProfile(metaData, null);
    }

    public ProfileKey registerProfile(ProfileMetaData metaData, Profile profile) throws Exception {
        if (metaData == null) {
            throw new IllegalArgumentException("null profile meta data");
        }
        try {
            return this.activationService.register(metaData, profile);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public void activateProfile(ProfileKey key) throws NoSuchProfileException, Exception {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.activationService.activate(key);
    }

    public void deactivateProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.activationService.deactivate(key);
    }

    public void unregisterProfile(ProfileKey key) throws NoSuchProfileException {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.activationService.uninstall(key);
    }

    public void validateProfile(ProfileKey key) throws Exception {
        if (key == null) {
            throw new IllegalArgumentException("null profile key");
        }
        this.activationService.validate(key);
    }
}

