/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.plugins.helpers;

import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.WeakHashMap;
import org.jboss.classloading.spi.dependency.Module;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.scanning.plugins.helpers.CachingResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.LazyUtilsProxyHandler;
import org.jboss.scanning.plugins.helpers.ReflectProviderUtilFactory;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinderUtilFactory;
import org.jboss.scanning.plugins.helpers.UtilFactory;
import org.jboss.scanning.plugins.visitor.ErrorHandler;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentUtilsFactory {
    private static Map<Class<?>, UtilFactory<?>> defaults = new WeakHashMap();

    public static <T> void addImplementation(Class<T> iface, UtilFactory<T> factory) {
        defaults.put(iface, factory);
    }

    public static <T> void removeImplementation(Class<T> iface) {
        defaults.remove(iface);
    }

    public static <T> T getAttachment(DeploymentUnit unit, Class<T> expectedType, T defaultValue) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        return DeploymentUtilsFactory.getAttachment(unit, expectedType.getName(), expectedType, defaultValue);
    }

    public static <T> T getAttachment(DeploymentUnit unit, String key, Class<T> expectedType, T defaultValue) {
        if (unit == null) {
            throw new IllegalArgumentException("Null deployment unit");
        }
        if (key == null) {
            throw new IllegalArgumentException("Null key");
        }
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expected type");
        }
        Object attachment = unit.getAttachment(key, expectedType);
        return (T)(attachment != null ? attachment : defaultValue);
    }

    public static <T> T getUtil(DeploymentUnit unit, Class<T> utilType) {
        return DeploymentUtilsFactory.getUtil(unit, utilType, false);
    }

    public static <T> T getUtil(DeploymentUnit unit, Class<T> utilType, boolean allowNull) {
        if (utilType == null) {
            throw new IllegalArgumentException("Null util type");
        }
        DeploymentUnit moduleUnit = DeploymentUtilsFactory.getModuleUnit(unit);
        Object util = moduleUnit.getAttachment(utilType);
        if (util == null && !allowNull) {
            UtilFactory<?> factory = defaults.get(utilType);
            if (factory == null) {
                throw new IllegalArgumentException("No util factory defined for " + utilType);
            }
            Object instance = factory.create(moduleUnit);
            util = utilType.cast(instance);
            moduleUnit.addAttachment(utilType, util);
        }
        return (T)util;
    }

    public static DeploymentUnit getModuleUnit(DeploymentUnit unit) {
        DeploymentUnit moduleUnit;
        if (unit == null) {
            throw new IllegalArgumentException("Null unit");
        }
        for (moduleUnit = unit; moduleUnit != null && !moduleUnit.isAttachmentPresent(Module.class); moduleUnit = moduleUnit.getParent()) {
        }
        if (moduleUnit == null) {
            throw new IllegalArgumentException("No module in unit: " + unit);
        }
        return moduleUnit;
    }

    public static <T> T getLazyUtilProxy(DeploymentUnit unit, Class<T> utilType) {
        LazyUtilsProxyHandler<T> handler = new LazyUtilsProxyHandler<T>(unit, utilType);
        Object proxy = Proxy.newProxyInstance(unit.getClassLoader(), new Class[]{utilType}, handler);
        return utilType.cast(proxy);
    }

    public static ReflectProvider getProvider(DeploymentUnit unit) {
        return DeploymentUtilsFactory.getUtil(unit, ReflectProvider.class);
    }

    public static ResourceOwnerFinder getFinder(DeploymentUnit unit) {
        return DeploymentUtilsFactory.getUtil(unit, ResourceOwnerFinder.class);
    }

    public static ErrorHandler getHandler(DeploymentUnit unit) {
        return DeploymentUtilsFactory.getUtil(unit, ErrorHandler.class, true);
    }

    public static void cleanup(Object util) {
        if (util instanceof CachingResourceOwnerFinder) {
            ((CachingResourceOwnerFinder)CachingResourceOwnerFinder.class.cast(util)).cleanup();
        }
    }

    static {
        DeploymentUtilsFactory.addImplementation(ReflectProvider.class, new ReflectProviderUtilFactory());
        DeploymentUtilsFactory.addImplementation(ResourceOwnerFinder.class, new ResourceOwnerFinderUtilFactory());
    }
}

