/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.naming.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import org.jboss.beans.metadata.api.annotations.Inject;
import org.jboss.beans.metadata.plugins.AbstractInjectionValueMetaData;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.injection.inject.Injector;
import org.jboss.injection.inject.naming.ContextInjectionPoint;
import org.jboss.injection.inject.naming.SwitchBoardOperator;
import org.jboss.injection.inject.pojo.GenericValueRetriever;
import org.jboss.injection.inject.spi.InjectionPoint;
import org.jboss.injection.inject.spi.ValueRetriever;
import org.jboss.injection.naming.switchboard.SwitchBoardComponentMetaData;
import org.jboss.injection.naming.switchboard.SwitchBoardMetaData;
import org.jboss.injection.resolve.naming.EnvironmentProcessor;
import org.jboss.injection.resolve.naming.ResolutionException;
import org.jboss.injection.resolve.spi.ResolverResult;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.reloaded.naming.deployers.javaee.JavaEEComponentInformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchBoardOperatorDeployer
extends AbstractSimpleRealDeployer<SwitchBoardMetaData> {
    private static final Logger log = Logger.getLogger(SwitchBoardOperatorDeployer.class);
    private JavaEEComponentInformer componentInformer;
    private EnvironmentProcessor<DeploymentUnit> environmentProcessor;

    public SwitchBoardOperatorDeployer() {
        super(SwitchBoardMetaData.class);
        this.setOutput(BeanMetaData.class);
    }

    public void deploy(DeploymentUnit unit, SwitchBoardMetaData switchBoardMetaData) throws DeploymentException {
        String componentName;
        EnvironmentProcessor<DeploymentUnit> environmentProcessor = this.getEnvironmentProcessor();
        if (environmentProcessor == null) {
            throw new IllegalStateException("SwitchBoardOperator deployers require an EnvironmentPorcessor, which has not been set.");
        }
        try {
            List results = environmentProcessor.process((Object)unit, new Environment[]{switchBoardMetaData});
            if (results != null && !results.isEmpty()) {
                this.deployBeanMetaData(unit, null, results);
            }
        }
        catch (ResolutionException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Failed to resolve module level references for " + unit), (Throwable)e);
        }
        if (switchBoardMetaData.getComponents() == null) {
            return;
        }
        HashMap componentsByName = new HashMap();
        for (SwitchBoardComponentMetaData switchBoardComponentMetaData : switchBoardMetaData.getComponents()) {
            componentName = switchBoardComponentMetaData.getComponentName();
            if (!componentsByName.containsKey(componentName)) {
                componentsByName.put(componentName, new LinkedList());
            }
            ((Collection)componentsByName.get(componentName)).add(switchBoardComponentMetaData);
        }
        for (Map.Entry entry : componentsByName.entrySet()) {
            componentName = (String)entry.getKey();
            Collection componentMetaData = (Collection)entry.getValue();
            try {
                List results = environmentProcessor.process((Object)unit, (Iterable)componentMetaData);
                if (results == null || results.isEmpty()) continue;
                this.deployBeanMetaData(unit, componentName, results);
            }
            catch (ResolutionException e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Failed to resolve references for component " + componentName + " in " + unit), (Throwable)e);
            }
        }
    }

    protected void deployBeanMetaData(DeploymentUnit unit, String componentName, List<ResolverResult<?>> resolverResults) {
        String name = this.getBeanName(unit, componentName);
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)SwitchBoardOperator.class.getName());
        ValueMetaData contextValueMetaData = this.createContextValueMetaData(unit, componentName);
        builder.addConstructorParameter(Context.class.getName(), contextValueMetaData);
        List<Injector<Context>> injectors = this.createInjectors(resolverResults);
        builder.addConstructorParameter(List.class.getName(), injectors);
        for (ResolverResult<?> resolverResult : resolverResults) {
            String beanName = resolverResult.getBeanName();
            if (beanName == null) continue;
            builder.addDependency((Object)beanName);
        }
        BeanMetaData beanMetaData = builder.getBeanMetaData();
        unit.getTopLevel().addAttachment(BeanMetaData.class.getName() + "." + name, (Object)beanMetaData, BeanMetaData.class);
        log.debugf("Deploying SwitchBoardOperator [%s] for deployment [%s]", new Object[]{name, unit});
    }

    protected ValueMetaData createContextValueMetaData(DeploymentUnit unit, String componentName) {
        String contextBeanName = "jboss.naming:" + this.getBeanNameQualifier(unit, componentName);
        return new AbstractInjectionValueMetaData((Object)contextBeanName, "context");
    }

    protected List<Injector<Context>> createInjectors(List<ResolverResult<?>> resolverResults) {
        ArrayList<Injector<Context>> injectors = new ArrayList<Injector<Context>>(resolverResults.size());
        for (ResolverResult<?> resolverResult : resolverResults) {
            Injector<Context> injector = this.createInjector(resolverResult);
            injectors.add(injector);
        }
        return injectors;
    }

    protected <V> Injector<Context> createInjector(ResolverResult<V> resolverResult) {
        ContextInjectionPoint injectionPoint = new ContextInjectionPoint(resolverResult.getRefName());
        Object value = resolverResult.getValue();
        GenericValueRetriever valueRetriever = new GenericValueRetriever(value);
        return new Injector((InjectionPoint)injectionPoint, (ValueRetriever)valueRetriever);
    }

    protected String getBeanName(DeploymentUnit deploymentUnit, String componentName) {
        return "jboss.naming:service=SwitchBoardOperator," + this.getBeanNameQualifier(deploymentUnit, componentName);
    }

    protected String getBeanNameQualifier(DeploymentUnit deploymentUnit, String componentName) {
        String applicationName = this.componentInformer.getApplicationName(deploymentUnit);
        String moduleName = this.componentInformer.getModulePath(deploymentUnit);
        StringBuilder builder = new StringBuilder();
        if (applicationName != null) {
            builder.append("application=").append(applicationName).append(",");
        }
        builder.append("module=").append(moduleName);
        if (componentName != null) {
            builder.append(",component=").append(componentName);
        }
        return builder.toString();
    }

    protected EnvironmentProcessor<DeploymentUnit> getEnvironmentProcessor() {
        return this.environmentProcessor;
    }

    @Inject
    public void setEnvironmentProcessor(EnvironmentProcessor<DeploymentUnit> environmentProcessor) {
        this.environmentProcessor = environmentProcessor;
    }

    @Inject
    public void setComponentInformer(JavaEEComponentInformer componentInformer) {
        this.componentInformer = componentInformer;
    }
}

