/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.tomcat;

import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.webservices.integration.util.WebMetaDataHelper;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.ServletClassProvider;

final class WebMetaDataModifier {
    private final Logger log = Logger.getLogger(WebMetaDataModifier.class);

    WebMetaDataModifier() {
    }

    void modify(Deployment dep) {
        JBossWebMetaData jbossWebMD = (JBossWebMetaData)WSHelper.getRequiredAttachment((Deployment)dep, JBossWebMetaData.class);
        this.configureEndpoints(dep, jbossWebMD);
        this.modifyContextRoot(dep, jbossWebMD);
    }

    private void configureEndpoints(Deployment dep, JBossWebMetaData jbossWebMD) {
        String transportClassName = this.getTransportClassName(dep);
        ClassLoader loader = dep.getInitialClassLoader();
        this.log.trace((Object)"Modifying servlets");
        for (JBossServletMetaData servletMD : jbossWebMD.getServlets()) {
            boolean isWebserviceEndpoint = ASHelper.getEndpointClass((ServletMetaData)servletMD, loader) != null;
            if (!isWebserviceEndpoint) continue;
            servletMD.setServletClass(transportClassName);
            String endpointClassName = servletMD.getServletClass();
            this.log.debug((Object)("Setting transport class: " + transportClassName + " for servlet: " + endpointClassName));
            List<ParamValueMetaData> initParams = WebMetaDataHelper.getServletInitParams((ServletMetaData)servletMD);
            WebMetaDataHelper.newParamValue("jboss.ws.endpoint", endpointClassName, initParams);
        }
    }

    private void modifyContextRoot(Deployment dep, JBossWebMetaData jbossWebMD) {
        String contextRoot = dep.getService().getContextRoot();
        this.log.debug((Object)("Setting context root: " + contextRoot + " for deployment: " + dep.getSimpleName()));
        jbossWebMD.setContextRoot(contextRoot);
    }

    private String getTransportClassName(Deployment dep) {
        String transportClassName = null;
        String transportClassProviderName = (String)dep.getProperty("stack.transport.class.provider");
        if (transportClassProviderName != null) {
            try {
                ServletClassProvider scp = (ServletClassProvider)Class.forName(transportClassProviderName).newInstance();
                transportClassName = scp.getServletClassName();
            }
            catch (Exception e) {
                this.log.warn((Object)"Cannot get transport class name from stack.transport.class.provider", (Throwable)e);
            }
        }
        if (transportClassName == null) {
            transportClassName = (String)dep.getProperty("stack.transport.class");
        }
        if (transportClassName == null) {
            throw new IllegalStateException("Cannot obtain deployment property : stack.transport.class");
        }
        return transportClassName;
    }
}

