/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.metadata;

import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.WebservicesMetaData;
import org.jboss.webservices.integration.metadata.PublishLocationAdapterImpl;
import org.jboss.webservices.integration.util.ASHelper;
import org.jboss.ws.Constants;
import org.jboss.wsf.common.integration.WSHelper;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PublishLocationAdapter;

abstract class AbstractMetaDataBuilderEJB {
    protected final Logger log = Logger.getLogger(this.getClass());

    AbstractMetaDataBuilderEJB() {
    }

    final EJBArchiveMetaData create(Deployment dep) {
        this.log.debug((Object)("Building JBoss agnostic meta data for EJB webservice deployment: " + dep.getSimpleName()));
        EJBArchiveMetaData ejbArchiveMD = new EJBArchiveMetaData();
        this.buildEnterpriseBeansMetaData(dep, ejbArchiveMD);
        this.buildWebservicesMetaData(dep, ejbArchiveMD);
        return ejbArchiveMD;
    }

    protected abstract void buildEnterpriseBeansMetaData(Deployment var1, EJBArchiveMetaData var2);

    private void buildWebservicesMetaData(Deployment dep, EJBArchiveMetaData ejbArchiveMD) {
        JBossMetaData jbossMD = (JBossMetaData)WSHelper.getRequiredAttachment((Deployment)dep, JBossMetaData.class);
        WebservicesMetaData webservicesMD = jbossMD.getWebservices();
        if (webservicesMD == null) {
            return;
        }
        String contextRoot = webservicesMD.getContextRoot();
        WebserviceDescriptionsMetaData wsDescriptionsMD = webservicesMD.getWebserviceDescriptions();
        if (wsDescriptionsMD != null) {
            PublishLocationAdapterImpl resolver = new PublishLocationAdapterImpl(wsDescriptionsMD);
            ejbArchiveMD.setPublishLocationAdapter((PublishLocationAdapter)resolver);
            WebserviceDescriptionMetaData wsDescriptionMD = ASHelper.getWebserviceDescriptionMetaData(wsDescriptionsMD);
            if (wsDescriptionMD != null) {
                if (!Constants.BC_CONTEXT_MODE && contextRoot == null && !this.hasContextRoot(ejbArchiveMD)) {
                    contextRoot = wsDescriptionMD.getWebserviceDescriptionName();
                }
                String configName = wsDescriptionMD.getConfigName();
                String configFile = wsDescriptionMD.getConfigFile();
                this.log.debug((Object)("Setting config name: " + configName));
                ejbArchiveMD.setConfigName(wsDescriptionMD.getConfigName());
                this.log.debug((Object)("Setting config file: " + configFile));
                ejbArchiveMD.setConfigFile(wsDescriptionMD.getConfigFile());
            }
        }
        ejbArchiveMD.setWebServiceContextRoot(contextRoot);
        this.log.debug((Object)("Setting context root: " + contextRoot));
    }

    private boolean hasContextRoot(EJBArchiveMetaData ejbArchiveMD) {
        Iterator ejbMDs = ejbArchiveMD.getEnterpriseBeans();
        while (ejbMDs.hasNext()) {
            EJBMetaData ejbMD = (EJBMetaData)ejbMDs.next();
            if (ejbMD.getPortComponentURI() == null) continue;
            return true;
        }
        return false;
    }
}

