/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.core.businessobject;

import java.io.Serializable;
import org.jboss.ejb3.common.registrar.spi.Ejb3RegistrarLocator;
import org.jboss.ejb3.core.businessobject.BusinessObjectFactory;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.impl.factory.session.stateful.StatefulSessionProxyFactory;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiStatefulSessionRegistrar;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class LegacyStatefulBusinessObjectFactory
implements BusinessObjectFactory {
    @Override
    public <B> B createBusinessObject(SessionContainer container, Serializable sessionId, Class<B> businessInterface) {
        Class<?>[] remoteInterfaces;
        assert (businessInterface != null) : "businessInterface is null";
        boolean isRemote = false;
        boolean found = false;
        for (Class<?> intf : remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container)) {
            if (!intf.getName().equals(businessInterface.getName())) continue;
            isRemote = true;
            found = true;
            break;
        }
        if (!found) {
            Class<?>[] localInterfaces;
            for (Class<?> intf : localInterfaces = ProxyFactoryHelper.getLocalAndBusinessLocalInterfaces(container)) {
                if (!intf.getName().equals(businessInterface.getName())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new IllegalStateException(businessInterface.getName() + " is not a business interface for container " + this);
        }
        String sfsbJndiRegistrarObjectStoreBindName = ((StatefulContainer)container).getJndiRegistrarBindName();
        JndiStatefulSessionRegistrar sfsbJndiRegistrar = (JndiStatefulSessionRegistrar)Ejb3RegistrarLocator.locateRegistrar().lookup((Object)sfsbJndiRegistrarObjectStoreBindName, JndiStatefulSessionRegistrar.class);
        JBossSessionBeanMetaData smd = container.getMetaData();
        String jndiName = !isRemote ? smd.getLocalJndiName() : smd.getJndiName();
        String proxyFactoryKey = sfsbJndiRegistrar.getProxyFactoryRegistryKey(jndiName, smd, !isRemote);
        StatefulSessionProxyFactory proxyFactory = (StatefulSessionProxyFactory)Ejb3RegistrarLocator.locateRegistrar().lookup((Object)proxyFactoryKey, StatefulSessionProxyFactory.class);
        Object proxy = proxyFactory.createProxyBusiness(sessionId, businessInterface.getName());
        return businessInterface.cast(proxy);
    }
}

