/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans.metadata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jboss.aop.microcontainer.beans.Aspect;
import org.jboss.aop.microcontainer.beans.ClassLoaderAwareGenericBeanFactory;
import org.jboss.aop.microcontainer.beans.metadata.AspectManagerAwareBeanMetaDataFactory;
import org.jboss.aop.microcontainer.beans.metadata.XmlLoadableRootElementUtil;
import org.jboss.beans.metadata.plugins.AbstractDependencyValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.xb.annotations.JBossXmlSchema;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JBossXmlSchema(namespace="urn:jboss:aop-beans:1.0", elementFormDefault=XmlNsForm.QUALIFIED)
@XmlRootElement(name="aspect")
@XmlType(name="aspectType", propOrder={"aliases", "annotations", "classLoader", "constructor", "properties", "create", "start", "depends", "demands", "supplies", "installs", "uninstalls", "installCallbacks", "uninstallCallbacks"})
public class AspectBeanMetaDataFactory
extends AspectManagerAwareBeanMetaDataFactory {
    private static final long serialVersionUID = 1L;
    private String scope = "PER_VM";
    private String factory;
    private String aspectName;
    private boolean initialisedName;
    private List<Element> elements;

    @XmlAttribute
    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    @XmlAttribute
    public void setFactory(String clazz) {
        this.factory = clazz;
        if (this.getBean() != null) {
            throw new RuntimeException("Cannot set both factory and clazz");
        }
        super.setBean(clazz);
    }

    public String getFactory() {
        return this.factory;
    }

    @XmlAttribute(name="class")
    public void setBean(String bean) {
        if (this.factory != null) {
            throw new RuntimeException("Cannot set both factory and clazz");
        }
        super.setBean(bean);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    @XmlAnyElement(lax=true)
    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public List<BeanMetaData> getBeans() {
        List beans;
        ArrayList<BeanMetaData> result = new ArrayList<BeanMetaData>();
        if (this.name == null) {
            this.name = super.getBean();
        }
        if (!this.initialisedName) {
            this.aspectName = this.name;
            this.name = "Factory$" + this.name;
            this.initialisedName = true;
        }
        if ((beans = super.getBeans()).size() != 1) {
            throw new RuntimeException("Wrong number of beans" + beans);
        }
        BeanMetaData factory = (BeanMetaData)beans.get(0);
        BeanMetaDataBuilder factoryBuilder = BeanMetaDataBuilder.createBuilder((BeanMetaData)factory);
        factoryBuilder.setBean(ClassLoaderAwareGenericBeanFactory.class.getName());
        result.add(factory);
        BeanMetaDataBuilder aspectBuilder = BeanMetaDataBuilder.createBuilder((String)this.aspectName, (String)Aspect.class.getName());
        aspectBuilder.addPropertyMetaData("scope", this.scope);
        aspectBuilder.addPropertyMetaData("name", this.aspectName);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", this.name);
        if (this.factory != null) {
            attributes.put("factory", this.factory);
        } else {
            attributes.put("class", this.bean);
        }
        attributes.put("scope", this.scope);
        if (this.elements != null && this.elements.size() > 0) {
            aspectBuilder.addPropertyMetaData("element", XmlLoadableRootElementUtil.getRootElementString(this.elements, this.getTagName(), attributes));
        }
        this.setAspectManagerProperty(aspectBuilder);
        if (this.factory != null) {
            aspectBuilder.addPropertyMetaData("factory", (Object)Boolean.TRUE);
        }
        result.add(aspectBuilder.getBeanMetaData());
        if (this.hasInjectedBeans(factory)) {
            this.configureWithDependencies(factoryBuilder, aspectBuilder);
        } else {
            this.configureNoDependencies(aspectBuilder);
        }
        return result;
    }

    private void configureWithDependencies(BeanMetaDataBuilder factoryBuilder, BeanMetaDataBuilder aspectBuilder) {
        aspectBuilder.addPropertyMetaData("adviceBean", this.name);
        factoryBuilder.addInstallWithThis("install", aspectBuilder.getBeanMetaData().getName());
        factoryBuilder.addUninstall("uninstall", aspectBuilder.getBeanMetaData().getName());
    }

    private void configureNoDependencies(BeanMetaDataBuilder aspectBuilder) {
        ValueMetaData inject = aspectBuilder.createInject((Object)this.name);
        aspectBuilder.addPropertyMetaData("advice", inject);
    }

    private boolean hasInjectedBeans(BeanMetaData beanMetaData) {
        ArrayList<ValueMetaData> dependencies = new ArrayList<ValueMetaData>();
        this.getDependencies(dependencies, (MetaDataVisitorNode)beanMetaData);
        for (ValueMetaData dep : dependencies) {
            if (((String)dep.getUnderlyingValue()).startsWith("jboss.kernel:service=")) continue;
            return true;
        }
        return false;
    }

    private void getDependencies(ArrayList<ValueMetaData> dependencies, MetaDataVisitorNode node) {
        Iterator children;
        if (node instanceof AbstractDependencyValueMetaData) {
            dependencies.add((ValueMetaData)((AbstractDependencyValueMetaData)node));
        }
        if ((children = node.getChildren()) != null) {
            while (children.hasNext()) {
                MetaDataVisitorNode child = (MetaDataVisitorNode)children.next();
                this.getDependencies(dependencies, child);
            }
        }
    }

    protected String getTagName() {
        return "aspect";
    }
}

