/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.InterceptorFactory;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.BindingEntry;
import org.jboss.aop.microcontainer.beans.InterceptorEntry;
import org.jboss.aop.microcontainer.beans.StackEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack {
    private AspectManager manager;
    private String name;
    private List<BindingEntry> advices;

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<BindingEntry> getAdvices() {
        return this.advices;
    }

    public void setAdvices(List<BindingEntry> advices) {
        this.advices = advices;
    }

    public List<InterceptorEntry> getClonedAdvices(Binding binding) {
        ArrayList<InterceptorEntry> entries = new ArrayList<InterceptorEntry>();
        for (BindingEntry entry : this.advices) {
            if (entry instanceof InterceptorEntry) {
                this.cloneAndAddEntry(entries, (InterceptorEntry)entry, binding);
                continue;
            }
            if (entry instanceof StackEntry) {
                List<InterceptorEntry> stackEntries = ((StackEntry)entry).getAdvices();
                for (InterceptorEntry cur : stackEntries) {
                    this.cloneAndAddEntry(entries, cur, binding);
                }
                continue;
            }
            throw new IllegalStateException("Invalid BindingEntry type " + entry);
        }
        return entries;
    }

    private void cloneAndAddEntry(List<InterceptorEntry> entries, InterceptorEntry entry, Binding binding) {
        InterceptorEntry cloned = (InterceptorEntry)entry.clone();
        cloned.setBinding(binding);
        entries.add(cloned);
    }

    public void start() {
        if (this.manager == null) {
            throw new IllegalStateException("Null manager");
        }
        if (this.name == null) {
            throw new IllegalStateException("Null name");
        }
        if (this.advices == null) {
            throw new IllegalStateException("Null advices");
        }
        ArrayList<InterceptorFactory> factories = new ArrayList<InterceptorFactory>();
        for (BindingEntry advice : this.advices) {
            if (advice instanceof InterceptorEntry) {
                factories.add(((InterceptorEntry)advice).getInterceptorFactory());
                continue;
            }
            if (advice instanceof StackEntry) {
                factories.addAll(Arrays.asList(((StackEntry)advice).getInterceptorFactories()));
                continue;
            }
            throw new IllegalStateException("Invalid BindingEntry type " + advice);
        }
        AdviceStack stack = new AdviceStack(this.name, factories);
        this.manager.addAdviceStack(stack);
    }

    public void stop() {
        this.manager.removeInterceptorStack(this.name);
    }
}

