/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.jms.client;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueSession;
import javax.jms.XASession;
import javax.jms.XATopicConnection;
import javax.jms.XATopicSession;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.SessionFailureListener;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.version.Version;
import org.hornetq.jms.client.HornetQConnectionMetaData;
import org.hornetq.jms.client.HornetQDestination;
import org.hornetq.jms.client.HornetQSession;
import org.hornetq.jms.client.JMSExceptionHelper;
import org.hornetq.utils.ConcurrentHashSet;
import org.hornetq.utils.UUIDGenerator;
import org.hornetq.utils.VersionLoader;

public class HornetQConnection
implements Connection,
QueueConnection,
TopicConnection,
XAConnection,
XAQueueConnection,
XATopicConnection {
    private static final Logger log = Logger.getLogger(HornetQConnection.class);
    public static final int TYPE_GENERIC_CONNECTION = 0;
    public static final int TYPE_QUEUE_CONNECTION = 1;
    public static final int TYPE_TOPIC_CONNECTION = 2;
    public static final SimpleString CONNECTION_ID_PROPERTY_NAME = new SimpleString("__HQ_CID");
    private final int connectionType;
    private final Set<HornetQSession> sessions = new ConcurrentHashSet();
    private final Set<SimpleString> tempQueues = new ConcurrentHashSet();
    private volatile boolean hasNoLocal;
    private volatile ExceptionListener exceptionListener;
    private volatile boolean justCreated = true;
    private volatile ConnectionMetaData metaData;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private final ClientSessionFactory sessionFactory;
    private final SimpleString uid;
    private final String username;
    private final String password;
    private final SessionFailureListener listener = new JMSFailureListener(this);
    private final Version thisVersion;
    private final int dupsOKBatchSize;
    private final int transactionBatchSize;
    private ClientSession initialSession;
    private final Exception creationStack;

    public HornetQConnection(String username, String password, int connectionType, String clientID, int dupsOKBatchSize, int transactionBatchSize, ClientSessionFactory sessionFactory) {
        this.username = username;
        this.password = password;
        this.connectionType = connectionType;
        this.clientID = clientID;
        this.sessionFactory = sessionFactory;
        this.uid = UUIDGenerator.getInstance().generateSimpleStringUUID();
        this.thisVersion = VersionLoader.getVersion();
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.transactionBatchSize = transactionBatchSize;
        this.creationStack = new Exception();
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 0);
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.clientID;
    }

    public void setClientID(String clientID) throws JMSException {
        this.checkClosed();
        if (this.clientID != null) {
            throw new IllegalStateException("Client id has already been set");
        }
        if (!this.justCreated) {
            throw new IllegalStateException("setClientID can only be called directly after the connection is created");
        }
        this.clientID = clientID;
        this.justCreated = false;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        if (this.metaData == null) {
            this.metaData = new HornetQConnectionMetaData(this.thisVersion);
        }
        return this.metaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        this.justCreated = false;
        return this.exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.checkClosed();
        this.exceptionListener = listener;
        this.justCreated = false;
    }

    public void start() throws JMSException {
        this.checkClosed();
        for (HornetQSession session : this.sessions) {
            session.start();
        }
        this.justCreated = false;
        this.started = true;
    }

    public void stop() throws JMSException {
        this.checkClosed();
        for (HornetQSession session : this.sessions) {
            session.stop();
        }
        this.justCreated = false;
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws JMSException {
        if (this.closed) {
            return;
        }
        this.sessionFactory.close();
        try {
            for (HornetQSession session : new HashSet<HornetQSession>(this.sessions)) {
                session.close();
            }
            try {
                if (!this.tempQueues.isEmpty()) {
                    for (SimpleString queueName : this.tempQueues) {
                        if (this.initialSession.isClosed()) continue;
                        try {
                            this.initialSession.deleteQueue(queueName);
                        }
                        catch (HornetQException hornetQException) {}
                    }
                }
            }
            finally {
                if (this.initialSession != null) {
                    this.initialSession.close();
                }
            }
            this.closed = true;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues(destination);
        return null;
    }

    private void checkTempQueues(Destination destination) throws JMSException {
        HornetQDestination jbdest = (HornetQDestination)destination;
        if (jbdest.isTemporary() && !this.containsTemporaryQueue(jbdest.getSimpleAddress())) {
            throw new JMSException("Can not create consumer for temporary destination " + destination + " from another JMS connection");
        }
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        if (this.connectionType == 1) {
            String msg = "Cannot create a durable connection consumer on a QueueConnection";
            throw new IllegalStateException(msg);
        }
        this.checkTempQueues((Destination)topic);
        return null;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 1);
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues((Destination)queue);
        return null;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(transacted, acknowledgeMode, false, 2);
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        this.checkClosed();
        this.checkTempQueues((Destination)topic);
        return null;
    }

    public XASession createXASession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 0);
    }

    public XAQueueSession createXAQueueSession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 1);
    }

    public XATopicSession createXATopicSession() throws JMSException {
        this.checkClosed();
        return this.createSessionInternal(true, 0, true, 2);
    }

    public void addTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.add(queueAddress);
    }

    public void removeTemporaryQueue(SimpleString queueAddress) {
        this.tempQueues.remove(queueAddress);
    }

    public boolean containsTemporaryQueue(SimpleString queueAddress) {
        return this.tempQueues.contains(queueAddress);
    }

    public boolean hasNoLocal() {
        return this.hasNoLocal;
    }

    public void setHasNoLocal() {
        this.hasNoLocal = true;
    }

    public SimpleString getUID() {
        return this.uid;
    }

    public void removeSession(HornetQSession session) {
        this.sessions.remove(session);
    }

    public ClientSession getInitialSession() {
        return this.initialSession;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            log.warn((Object)"I'm closing a JMS connection you left open. Please make sure you close all JMS connections explicitly before letting them go out of scope!");
            log.warn((Object)"The JMS connection you didn't close was created here:", (Throwable)this.creationStack);
            this.close();
        }
    }

    protected HornetQSession createSessionInternal(boolean transacted, int acknowledgeMode, boolean isXA, int type) throws JMSException {
        if (transacted) {
            acknowledgeMode = 0;
        }
        try {
            ClientSession session;
            if (acknowledgeMode == 0) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, false, false, this.sessionFactory.isPreAcknowledge(), this.transactionBatchSize);
            } else if (acknowledgeMode == 1) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.isPreAcknowledge(), 0);
            } else if (acknowledgeMode == 3) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, true, this.sessionFactory.isPreAcknowledge(), this.dupsOKBatchSize);
            } else if (acknowledgeMode == 2) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, this.sessionFactory.isPreAcknowledge(), this.transactionBatchSize);
            } else if (acknowledgeMode == 100) {
                session = this.sessionFactory.createSession(this.username, this.password, isXA, true, false, true, this.transactionBatchSize);
            } else {
                throw new IllegalArgumentException("Invalid ackmode: " + acknowledgeMode);
            }
            this.justCreated = false;
            session.addFailureListener(this.listener);
            HornetQSession jbs = new HornetQSession(this, transacted, isXA, acknowledgeMode, session, type);
            this.sessions.add(jbs);
            if (this.started) {
                session.start();
            }
            return jbs;
        }
        catch (HornetQException e) {
            throw JMSExceptionHelper.convertFromHornetQException(e);
        }
    }

    private void checkClosed() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("Connection is closed");
        }
    }

    public void authorize() throws JMSException {
        try {
            this.initialSession = this.sessionFactory.createSession(this.username, this.password, false, false, false, false, 0);
            this.initialSession.addFailureListener(this.listener);
        }
        catch (HornetQException me) {
            throw JMSExceptionHelper.convertFromHornetQException(me);
        }
    }

    private static class JMSFailureListener
    implements SessionFailureListener {
        private final WeakReference<HornetQConnection> connectionRef;

        JMSFailureListener(HornetQConnection connection) {
            this.connectionRef = new WeakReference<HornetQConnection>(connection);
        }

        public synchronized void connectionFailed(HornetQException me) {
            block5: {
                if (me == null) {
                    return;
                }
                HornetQConnection conn = (HornetQConnection)this.connectionRef.get();
                if (conn != null) {
                    try {
                        final ExceptionListener exceptionListener = conn.getExceptionListener();
                        if (exceptionListener != null) {
                            final JMSException je = new JMSException(me.toString());
                            je.initCause((Throwable)me);
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    exceptionListener.onException(je);
                                }
                            }).start();
                        }
                    }
                    catch (JMSException e) {
                        if (conn.closed) break block5;
                        log.error((Object)"Failed to get exception listener", (Throwable)e);
                    }
                }
            }
        }

        public void beforeReconnect(HornetQException me) {
        }
    }
}

