/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.load.metric.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import org.jboss.modcluster.load.metric.LoadContext;
import org.jboss.modcluster.load.metric.impl.SelfSourcedLoadMetric;

public class HeapMemoryUsageLoadMetric
extends SelfSourcedLoadMetric {
    private final MemoryMXBean bean;

    public HeapMemoryUsageLoadMetric() {
        this(ManagementFactory.getMemoryMXBean());
    }

    public HeapMemoryUsageLoadMetric(MemoryMXBean bean) {
        this.bean = bean;
    }

    public double getLoad(LoadContext context) {
        MemoryUsage usage = this.bean.getHeapMemoryUsage();
        long max = usage.getMax();
        double total = max >= 0L ? (double)max : (double)usage.getCommitted();
        return (double)usage.getUsed() / total;
    }
}

