/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.standardInterceptors;

import org.jacorb.config.Configuration;
import org.jacorb.orb.ORB;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.standardInterceptors.CodeSetInfoInterceptor;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;
import org.slf4j.Logger;

public class IORInterceptorInitializer
extends LocalObject
implements ORBInitializer {
    public void post_init(ORBInitInfo oRBInitInfo) {
        ORB oRB = ((ORBInitInfoImpl)oRBInitInfo).getORB();
        Configuration configuration = oRB.getConfiguration();
        Logger logger = configuration.getLogger("org.jacorb.interceptors.ior_init");
        try {
            int n = configuration.getAttributeAsInteger("jacorb.giop_minor_version", 2);
            if (n > 0) {
                oRBInitInfo.add_ior_interceptor(new CodeSetInfoInterceptor(oRB));
            }
        }
        catch (Exception exception) {
            logger.error("unexpected exception", (Throwable)exception);
            throw new INTERNAL(exception.toString());
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
    }
}

