/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.spi.lazy;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.lazy.LazyInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyProxyFactory {
    private static volatile LazyInitializer initializer;
    private static Map<String, String> initializerMap;

    protected static LazyInitializer getInitializer(KernelConfigurator configurator) {
        if (initializer == null) {
            for (Map.Entry<String, String> entry : initializerMap.entrySet()) {
                if (LazyProxyFactory.testLibExists(entry.getKey()) && (initializer = LazyProxyFactory.createInitializer(configurator, entry.getValue())) != null) break;
            }
        }
        if (initializer == null) {
            throw new IllegalArgumentException("Cannot initialize LazyInitializater, check classpath for missing classes.");
        }
        return initializer;
    }

    protected static boolean testLibExists(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected static LazyInitializer createInitializer(KernelConfigurator configurator, String initializerClassName) {
        try {
            BeanInfo beanInfo = configurator.getBeanInfo(initializerClassName, LazyInitializer.class.getClassLoader());
            Object result = beanInfo.newInstance();
            return (LazyInitializer)LazyInitializer.class.cast(result);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Object getProxy(Kernel kernel, String bean, boolean exposeClass, Set<String> interfaces) throws Throwable {
        LazyInitializer lazyInitializer = LazyProxyFactory.getInitializer(kernel.getConfigurator());
        return lazyInitializer.initializeProxy(kernel, bean, exposeClass, interfaces);
    }

    static {
        initializerMap = new LinkedHashMap<String, String>();
        initializerMap.put("javassist.util.proxy.ProxyObject", "org.jboss.kernel.plugins.lazy.JavassistLazyInitializer");
        initializerMap.put("org.jboss.aop.proxy.container.AOPProxyFactoryParameters", "org.jboss.aop.microcontainer.lazy.JBossAOPLazyInitializer");
        initializerMap.put("java.lang.reflect.Proxy", "org.jboss.kernel.plugins.lazy.JDKLazyInitializer");
    }
}

