/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.security.SecurityActions;
import org.jboss.ws.extensions.security.exception.FailedAuthenticationException;
import org.jboss.ws.extensions.security.exception.WSSecurityException;

public class SecurityStore {
    private static Logger log = Logger.getLogger(SecurityStore.class);
    private KeyStore keyStore;
    private String keyStorePassword;
    private KeyStore trustStore;
    private String trustStorePassword;
    private HashMap<String, String> keyPasswords;

    public SecurityStore() throws WSSecurityException {
        this(null, null, null, null, null, null, null);
    }

    public SecurityStore(URL keyStoreURL, String keyStoreType, String keyStorePassword, HashMap<String, String> keyPasswords) throws WSSecurityException {
        this.loadKeyStore(keyStoreURL, keyStoreType, keyStorePassword);
        this.loadTrustStore(keyStoreURL, keyStoreType, keyStorePassword);
        this.keyPasswords = keyPasswords;
    }

    public SecurityStore(URL keyStoreURL, String keyStoreType, String keyStorePassword, HashMap<String, String> keyPasswords, URL trustStoreURL, String trustStoreType, String trustStorePassword) throws WSSecurityException {
        this.loadKeyStore(keyStoreURL, keyStoreType, keyStorePassword);
        this.loadTrustStore(trustStoreURL, trustStoreType, trustStorePassword);
        this.keyPasswords = keyPasswords;
    }

    private void loadKeyStore(URL keyStoreURL, String keyStoreType, String keyStorePassword) throws WSSecurityException {
        if (keyStorePassword == null) {
            keyStorePassword = SecurityActions.getSystemProperty("org.jboss.ws.wsse.keyStorePassword");
        }
        this.keyStore = this.loadStore("org.jboss.ws.wsse.keyStore", "Keystore", keyStoreURL, keyStoreType, keyStorePassword);
        this.keyStorePassword = keyStorePassword;
    }

    private void loadTrustStore(URL trustStoreURL, String trustStoreType, String trustStorePassword) throws WSSecurityException {
        if (trustStorePassword == null) {
            trustStorePassword = SecurityActions.getSystemProperty("org.jboss.ws.wsse.trustStorePassword");
        }
        this.trustStore = this.loadStore("org.jboss.ws.wsse.trustStore", "Truststore", trustStoreURL, trustStoreType, trustStorePassword);
        this.trustStorePassword = trustStorePassword;
    }

    private KeyStore loadStore(String property, String type, URL storeURL, String storeType, String storePassword) throws WSSecurityException {
        if (storeURL == null) {
            String defaultStore = SecurityActions.getSystemProperty(property);
            if (defaultStore == null) {
                return null;
            }
            File storeFile = new File(defaultStore);
            try {
                storeURL = storeFile.toURL();
            }
            catch (MalformedURLException e) {
                throw new WSSecurityException("Problems loading " + type + ": " + e.getMessage(), e);
            }
        }
        if (storeType == null) {
            storeType = SecurityActions.getSystemProperty(property + "Type");
        }
        if (storeType == null) {
            storeType = "jks";
        }
        KeyStore keyStore = null;
        InputStream stream = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("loadStore: " + storeURL));
            }
            if ((stream = storeURL.openStream()) == null) {
                throw new WSSecurityException("Cannot load store from: " + storeURL);
            }
            keyStore = KeyStore.getInstance(storeType);
            if (keyStore == null) {
                throw new WSSecurityException("Cannot get keystore for type: " + storeType);
            }
            String decryptedPassword = this.decryptPassword(storePassword);
            if (decryptedPassword == null) {
                throw new WSSecurityException("Cannot decrypt store password");
            }
            keyStore.load(stream, decryptedPassword.toCharArray());
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (WSSecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WSSecurityException("Problems loading " + type + ": " + ex.getMessage(), ex);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
        return keyStore;
    }

    private String decryptPassword(String password) throws WSSecurityException {
        log.trace((Object)("decrypt password: " + password));
        if (password == null) {
            throw new WSSecurityException("Invalid null password for security store");
        }
        if (password.charAt(0) == '{') {
            StringTokenizer tokenizer = new StringTokenizer(password, "{}");
            String keyStorePasswordCmdType = tokenizer.nextToken();
            String keyStorePasswordCmd = tokenizer.nextToken();
            if (keyStorePasswordCmdType.equals("EXT")) {
                password = this.execPasswordCmd(keyStorePasswordCmd);
            } else if (keyStorePasswordCmdType.equals("CLASS")) {
                password = this.invokePasswordClass(keyStorePasswordCmd);
            } else {
                throw new WSSecurityException("Unknown keyStorePasswordCmdType: " + keyStorePasswordCmdType);
            }
        }
        if (password == null) {
            throw new WSSecurityException("Cannot decrypt password, result is null");
        }
        log.trace((Object)("decrypted password: " + password));
        return password;
    }

    private String execPasswordCmd(String keyStorePasswordCmd) throws WSSecurityException {
        boolean debugEnabled = log.isDebugEnabled();
        if (debugEnabled) {
            log.debug((Object)("Executing cmd: " + keyStorePasswordCmd));
        }
        try {
            String password = null;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(keyStorePasswordCmd);
            int status = p.waitFor();
            if (status == 0) {
                InputStream stdin = p.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stdin));
                password = reader.readLine();
                stdin.close();
            } else {
                InputStream stderr = p.getErrorStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(stderr));
                String line = reader.readLine();
                while (line != null) {
                    log.error((Object)line);
                    line = reader.readLine();
                }
                reader.close();
                stderr.close();
            }
            if (debugEnabled) {
                log.debug((Object)("Command exited with: " + status));
            }
            return password;
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems executing password cmd: " + keyStorePasswordCmd, e);
        }
    }

    private String invokePasswordClass(String keyStorePasswordCmd) throws WSSecurityException {
        String password = null;
        String classname = keyStorePasswordCmd;
        String ctorArg = null;
        int colon = keyStorePasswordCmd.indexOf(58);
        if (colon > 0) {
            classname = keyStorePasswordCmd.substring(0, colon);
            ctorArg = keyStorePasswordCmd.substring(colon + 1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading class: " + classname + ", ctorArg=" + ctorArg));
        }
        try {
            Object[] args;
            Class[] sig;
            ClassLoader loader = SecurityActions.getContextClassLoader();
            Class<?> c = loader.loadClass(classname);
            Object instance = null;
            if (ctorArg != null) {
                sig = new Class[]{String.class};
                Constructor<?> ctor = c.getConstructor(sig);
                args = new Object[]{ctorArg};
                instance = ctor.newInstance(args);
            } else {
                instance = c.newInstance();
            }
            try {
                log.debug((Object)"Checking for toCharArray");
                sig = new Class[]{};
                Method toCharArray = c.getMethod("toCharArray", sig);
                args = new Object[]{};
                log.debug((Object)"Invoking toCharArray");
                password = new String((char[])toCharArray.invoke(instance, args));
            }
            catch (NoSuchMethodException e) {
                log.debug((Object)"No toCharArray found, invoking toString");
                password = instance.toString();
            }
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems loading or invoking Password class : " + classname, e);
        }
        return password;
    }

    public static byte[] getSubjectKeyIdentifier(X509Certificate cert) {
        byte[] encoded = cert.getExtensionValue("2.5.29.14");
        if (encoded == null) {
            return null;
        }
        int trunc = encoded.length - 4;
        byte[] identifier = new byte[trunc];
        System.arraycopy(encoded, 4, identifier, 0, trunc);
        return identifier;
    }

    public X509Certificate getCertificate(String alias) throws WSSecurityException {
        X509Certificate cert;
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            cert = (X509Certificate)this.keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        if (cert == null) {
            throw new WSSecurityException("Certificate (" + alias + ") not in keystore");
        }
        return cert;
    }

    public X509Certificate getCertificateByPublicKey(PublicKey key) throws WSSecurityException {
        if (key == null) {
            return null;
        }
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            Enumeration<String> i = this.keyStore.aliases();
            while (i.hasMoreElements()) {
                String alias = i.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate) || !cert.getPublicKey().equals(key)) continue;
                return (X509Certificate)cert;
            }
            return null;
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
    }

    public X509Certificate getCertificateBySubjectKeyIdentifier(byte[] identifier) throws WSSecurityException {
        if (identifier == null) {
            return null;
        }
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            Enumeration<String> i = this.keyStore.aliases();
            while (i.hasMoreElements()) {
                byte[] subjectKeyIdentifier;
                String alias = i.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate) || (subjectKeyIdentifier = SecurityStore.getSubjectKeyIdentifier((X509Certificate)cert)) == null || !Arrays.equals(identifier, subjectKeyIdentifier)) continue;
                return (X509Certificate)cert;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        return null;
    }

    public X509Certificate getCertificateByIssuerSerial(String issuer, String serial) throws WSSecurityException {
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            Enumeration<String> i = this.keyStore.aliases();
            while (i.hasMoreElements()) {
                X509Certificate x509;
                String alias = i.nextElement();
                Certificate cert = this.keyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate) || !issuer.equals(((Object)(x509 = (X509Certificate)cert).getIssuerDN()).toString()) || !serial.equals(x509.getSerialNumber().toString())) continue;
                return x509;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems retrieving cert: " + e.getMessage(), e);
        }
        return null;
    }

    public PrivateKey getPrivateKey(String alias) throws WSSecurityException {
        PrivateKey key;
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            String password = this.keyStorePassword;
            if (this.keyPasswords != null && this.keyPasswords.containsKey(alias)) {
                password = this.keyPasswords.get(alias);
            }
            key = (PrivateKey)this.keyStore.getKey(alias, this.decryptPassword(password).toCharArray());
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving private key: " + e.getMessage(), e);
        }
        if (key == null) {
            throw new WSSecurityException("Private key (" + alias + ") not in keystore");
        }
        return key;
    }

    public PrivateKey getPrivateKey(X509Certificate cert) throws WSSecurityException {
        if (this.keyStore == null) {
            throw new WSSecurityException("KeyStore not set.");
        }
        try {
            String alias = this.keyStore.getCertificateAlias(cert);
            return this.getPrivateKey(alias);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems retrieving private key: " + e.getMessage(), e);
        }
    }

    public void validateCertificate(X509Certificate cert) throws WSSecurityException {
        PKIXParameters parameters;
        CertPathValidator cpv;
        CertPath cp;
        try {
            cert.checkValidity();
        }
        catch (Exception e) {
            log.debug((Object)"Certificate is invalid", (Throwable)e);
            throw new FailedAuthenticationException();
        }
        if (this.keyStore == null) {
            throw new WSSecurityException("TrustStore not set.");
        }
        try {
            if (this.trustStore.getCertificateAlias(cert) != null) {
                return;
            }
        }
        catch (KeyStoreException e) {
            throw new WSSecurityException("Problems searching truststore", e);
        }
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(1);
        list.add(cert);
        try {
            cp = CertificateFactory.getInstance("X.509").generateCertPath(list);
            cpv = CertPathValidator.getInstance("PKIX");
            parameters = new PKIXParameters(this.trustStore);
            parameters.setRevocationEnabled(false);
        }
        catch (Exception e) {
            throw new WSSecurityException("Problems setting up certificate validation", e);
        }
        try {
            cpv.validate(cp, parameters);
        }
        catch (CertPathValidatorException cpve) {
            log.debug((Object)"Certificate is invalid:", (Throwable)cpve);
            throw new FailedAuthenticationException();
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException("Problems setting up certificate validation", e);
        }
    }
}

