/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.eventing.jaxws;

import java.net.URI;
import java.net.URISyntaxException;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.ws.Action;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AttributedURI;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.annotation.EndpointConfig;
import org.jboss.ws.extensions.eventing.common.EventingEndpointBase;
import org.jboss.ws.extensions.eventing.jaxws.EndpointReferenceType;
import org.jboss.ws.extensions.eventing.jaxws.EventSourceEndpoint;
import org.jboss.ws.extensions.eventing.jaxws.Subscribe;
import org.jboss.ws.extensions.eventing.jaxws.SubscribeResponse;
import org.jboss.ws.extensions.eventing.mgmt.Filter;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionError;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionTicket;

@WebService(name="EventSource", portName="EventSourcePort", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", wsdlLocation="/WEB-INF/wsdl/wind.wsdl")
@EndpointConfig(configName="Standard WSAddressing Endpoint")
public abstract class AbstractEventSourceEndpoint
extends EventingEndpointBase
implements EventSourceEndpoint {
    @Override
    @WebMethod(operationName="SubscribeOp")
    @WebResult(name="SubscribeResponse", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body")
    @Action(input="http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe", output="http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse")
    public SubscribeResponse subscribeOp(@WebParam(name="Subscribe", targetNamespace="http://schemas.xmlsoap.org/ws/2004/08/eventing", partName="body") Subscribe request) {
        try {
            AddressingProperties inProps = AbstractEventSourceEndpoint.getAddrProperties();
            AttributedURI eventSourceURI = inProps.getTo();
            this.getLogger().debug((Object)("Subscribe request for event source: " + eventSourceURI.getURI()));
            this.assertSubscriberEndpoints(request);
            EndpointReferenceType notifyTo = request.getDelivery().getNotifyTo();
            EndpointReferenceType endTo = request.getEndTo();
            Filter filter = null;
            if (request.getFilter() != null) {
                try {
                    filter = new Filter(new URI(request.getFilter().getDialect()), (String)request.getFilter().getContent().get(0));
                }
                catch (URISyntaxException e) {
                    throw new WSException(e);
                }
            }
            SubscriptionManagerMBean subscriptionManager = this.getSubscriptionManager();
            SubscriptionTicket ticket = subscriptionManager.subscribe(eventSourceURI.getURI(), notifyTo, endTo, request.getExpires(), filter);
            SubscribeResponse res = new SubscribeResponse();
            res.setExpires(ticket.getExpires());
            res.setSubscriptionManager(ticket.getSubscriptionManager());
            return res;
        }
        catch (SubscriptionError e) {
            throw new SOAPFaultException(this.buildFaultQName(e.getSubcode()), e.getReason(), null, null);
        }
    }

    private void assertSubscriberEndpoints(Subscribe request) {
        if (null == request.getDelivery().getNotifyTo() || null == request.getEndTo()) {
            throw new SOAPFaultException(this.buildFaultQName("InvalidMessage"), "Subcriber endpoint information missing from request", null, null);
        }
    }

    protected abstract Logger getLogger();
}

