/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws.spi.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.ws.core.client.transport.NettyTransportOutputStream;
import org.jboss.ws.core.jaxws.spi.http.AbstractNettyMessage;

public final class NettyHttp11Message
extends AbstractNettyMessage {
    private static final int CHUNK_SIZE = 1024;
    private boolean headersWritten;

    public NettyHttp11Message(Channel channel, HttpRequest request) {
        super(HttpVersion.HTTP_1_1, channel, request);
    }

    @Override
    public InputStream getInputStream() {
        return new ChannelBufferInputStream(this.getRequest().getContent());
    }

    @Override
    public OutputStream getOutputStream() {
        return new ChunkingOutputStream(this, new NettyTransportOutputStream(this.getChannel(), 1024));
    }

    private void flushHeaders() {
        if (this.headersWritten) {
            return;
        }
        this.headersWritten = true;
        if (this.getStatus() == null) {
            this.setStatus(HttpResponseStatus.OK.getCode());
        }
        if (this.getHeader("Content-Type") == null) {
            this.setHeader("Content-Type", "text/xml; charset=UTF-8");
        }
        this.setHeader("Transfer-Encoding", "chunked");
        this.setCookies();
        this.getChannel().write((Object)this);
    }

    private static final class ChunkingOutputStream
    extends OutputStream {
        private final NettyTransportOutputStream delegee;
        private final NettyHttp11Message message;

        public ChunkingOutputStream(NettyHttp11Message message, NettyTransportOutputStream os) {
            this.message = message;
            this.delegee = os;
        }

        @Override
        public void write(int b) throws IOException {
            this.message.flushHeaders();
            this.delegee.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.message.flushHeaders();
            this.delegee.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.message.flushHeaders();
            this.delegee.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.delegee.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegee.close();
            this.delegee.getChannelFuture().awaitUninterruptibly();
        }
    }
}

