/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import org.jgroups.Address;
import org.jgroups.stack.DefaultRetransmitter;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, sequential=true)
public class RetransmitterTest {
    private final Address sender = Util.createRandomAddress();
    private TimeScheduler timer;
    private Retransmitter xmitter;

    @BeforeMethod
    void initTimer() {
        this.timer = new DefaultTimeScheduler();
        this.xmitter = new DefaultRetransmitter(this.sender, new MyXmitter(), this.timer);
        this.xmitter.setRetransmitTimeouts(new StaticInterval(1000L, 2000L, 4000L, 8000L));
        this.xmitter.reset();
    }

    @AfterMethod
    void destroyTimer() throws InterruptedException {
        this.timer.stop();
    }

    public void testNoEntry() {
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)0, (int)size);
    }

    public void testSingleEntry() {
        this.xmitter.add(1L, 1L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)1, (int)size);
    }

    public void testEntry() {
        this.xmitter.add(1L, 10L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)10, (int)size);
    }

    public void testMultipleEntries() {
        this.xmitter.add(1L, 10L);
        int size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)10, (int)size);
        this.xmitter.add(12L, 13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)12, (int)size);
        this.xmitter.remove(5L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)11, (int)size);
        this.xmitter.remove(13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)10, (int)size);
        this.xmitter.remove(1L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)9, (int)size);
        this.xmitter.remove(13L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)9, (int)size);
        this.xmitter.remove(12L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)8, (int)size);
        for (int i = 8; i >= 0; --i) {
            this.xmitter.remove(i);
        }
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)2, (int)size);
        this.xmitter.remove(10L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)1, (int)size);
        this.xmitter.remove(9L);
        size = this.xmitter.size();
        System.out.println("xmitter: " + this.xmitter);
        Assert.assertEquals((int)0, (int)size);
    }

    static class MyXmitter
    implements Retransmitter.RetransmitCommand {
        MyXmitter() {
        }

        @Override
        public void retransmit(long first_seqno, long last_seqno, Address sender) {
        }
    }
}

