/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.util.Util;

public class ConnectChannelTest {
    private static final Log LOGGER = LogFactory.getLog(ConnectChannelTest.class);
    private final int nbExpectedHosts;
    private final int nbChannels;

    public ConnectChannelTest(int num_hosts, int num_channels) {
        this.nbExpectedHosts = num_hosts;
        this.nbChannels = num_channels;
    }

    private static void initializeJMX() {
        String port = System.getProperty("JMXPort", "5000");
        try {
            String host = InetAddress.getLocalHost().getHostName() + ":" + port;
            HashMap env = new HashMap();
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            LocateRegistry.createRegistry(Integer.parseInt(port));
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + host + "/jndi/rmi://" + host + "/jmxrmi");
            JMXConnectorServer cs = JMXConnectorServerFactory.newJMXConnectorServer(url, env, beanServer);
            cs.start();
        }
        catch (Exception e) {
            LOGGER.error("Can not initialize JMX server", e);
        }
    }

    public boolean start() throws ChannelException {
        ConnectChannelTest.initializeJMX();
        LOGGER.info("Starting test with " + this.nbExpectedHosts + " expected members");
        for (int i = 0; i < this.nbChannels; ++i) {
            JChannel c = new JChannel();
            c.setName(String.valueOf(i));
            long startingTime = System.currentTimeMillis();
            c.setReceiver(new ChannelHandler(c, System.currentTimeMillis()));
            try {
                c.connect("ConnectTestCluster");
            }
            catch (ChannelException e) {
                LOGGER.error("Can't connect channel", e);
                return false;
            }
            long time = System.currentTimeMillis();
            LOGGER.info("Channel c" + i + " connected in " + (time - startingTime) + " ms");
        }
        return true;
    }

    public static void main(String[] args) throws ChannelException {
        int num_expected_hosts = Integer.parseInt(args[0]);
        int num_channels = Integer.parseInt(args[1]);
        ConnectChannelTest test = new ConnectChannelTest(num_expected_hosts, num_channels);
        test.start();
    }

    private final class ChannelHandler
    extends ReceiverAdapter {
        private final Vector<Address> members = new Vector();
        private final JChannel ch;
        private final String channel_name;
        private final Address local_addr;
        private long date;

        public ChannelHandler(JChannel ch, long date) {
            this.ch = ch;
            this.date = date;
            this.channel_name = ch.getName();
            this.local_addr = ch.getAddress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View newView) {
            if (newView == null) {
                return;
            }
            Vector<Address> currentMembers = newView.getMembers();
            Vector<Address> vector = this.members;
            synchronized (vector) {
                LOGGER.debug("Channel " + this.channel_name + " View accepted, coordinator status " + Util.isCoordinator(newView, this.local_addr));
                for (Address address : currentMembers) {
                    if (this.members.contains(address)) continue;
                    LOGGER.debug("Channel " + this.channel_name + " Member joined " + address);
                }
                for (Address address : this.members) {
                    if (currentMembers.contains(address)) continue;
                    LOGGER.debug("Channel " + this.channel_name + " Member left " + address);
                }
                this.members.removeAllElements();
                this.members.addAll(currentMembers);
            }
            if (newView instanceof MergeView) {
                LOGGER.error("Channel " + this.channel_name + " View merged " + newView);
            }
            if (this.members.size() == ConnectChannelTest.this.nbExpectedHosts) {
                long time = System.currentTimeMillis();
                LOGGER.info("Channel " + this.channel_name + " All expected members joined in " + (time - this.date) + " ms");
            }
        }
    }
}

