/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Transport;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.conf.PropertyConverter;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Tuple;
import org.jgroups.util.Util;

public class ProtocolStack
extends Protocol
implements Transport {
    public static final int ABOVE = 1;
    public static final int BELOW = 2;
    private static final ConcurrentMap<String, Tuple<TP, RefCounter>> singleton_transports = new ConcurrentHashMap<String, Tuple<TP, RefCounter>>();
    private Protocol top_prot;
    private Protocol bottom_prot;
    private JChannel channel;
    private volatile boolean stopped = true;
    private final TP.ProbeHandler props_handler = new TP.ProbeHandler(){

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            for (String key : keys) {
                if (!key.equals("props")) continue;
                String tmp = ProtocolStack.this.printProtocolSpec(true);
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put("props", tmp);
                return map;
            }
            return null;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"props"};
        }
    };

    public ProtocolStack(JChannel channel) throws ChannelException {
        this.channel = channel;
        Class<ClassConfigurator> tmp = ClassConfigurator.class;
        try {
            tmp.newInstance();
        }
        catch (Exception e) {
            throw new ChannelException("failed initializing ClassConfigurator", e);
        }
    }

    public ProtocolStack() {
    }

    public void setChannel(JChannel ch) {
        this.channel = ch;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        TP transport = this.getTransport();
        return transport != null ? transport.getThreadFactory() : null;
    }

    @Deprecated
    public static ThreadFactory getTimerThreadFactory() {
        throw new UnsupportedOperationException("get the timer thread factory directly from the transport");
    }

    public void setThreadFactory(ThreadFactory f) {
    }

    public static void setTimerThreadFactory(ThreadFactory f) {
    }

    public int getTimerThreads() {
        TimeScheduler timer;
        TP transport = this.getTransport();
        if (transport != null && (timer = transport.getTimer()) != null) {
            return timer.getMinThreads();
        }
        return -1;
    }

    public List<Protocol> getProtocols() {
        ArrayList<Protocol> v = new ArrayList<Protocol>(15);
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            v.add(p);
        }
        return v;
    }

    public List<Protocol> copyProtocols(ProtocolStack targetStack) throws IllegalAccessException, InstantiationException {
        List<Protocol> list = this.getProtocols();
        ArrayList<Protocol> retval = new ArrayList<Protocol>(list.size());
        for (Protocol prot : list) {
            Protocol new_prot = (Protocol)prot.getClass().newInstance();
            new_prot.setProtocolStack(targetStack);
            retval.add(new_prot);
            for (Class<?> clazz = prot.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                Method[] methods;
                Field[] fields;
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Property.class)) continue;
                    Object value = Configurator.getField(field, prot);
                    Configurator.setField(field, new_prot, value);
                }
                for (Method method : methods = clazz.getDeclaredMethods()) {
                    String methodName = method.getName();
                    if (!method.isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(method)) continue;
                    Property annotation = method.getAnnotation(Property.class);
                    LinkedList<String> possible_names = new LinkedList<String>();
                    if (annotation.name() != null) {
                        possible_names.add(annotation.name());
                    }
                    possible_names.add(methodName.substring(3));
                    possible_names.add(Util.methodNameToAttributeName(methodName));
                    Field field = ProtocolStack.findField(prot, possible_names);
                    if (field == null) continue;
                    Object value = Configurator.getField(field, prot);
                    Configurator.setField(field, new_prot, value);
                }
            }
        }
        return retval;
    }

    private static Field findField(Object target, List<String> possible_names) {
        if (target == null) {
            return null;
        }
        for (Class<?> clazz = target.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (String name : possible_names) {
                try {
                    Field field = clazz.getDeclaredField(name);
                    if (field == null) continue;
                    return field;
                }
                catch (NoSuchFieldException e) {
                }
            }
        }
        return null;
    }

    @Override
    public TP getTransport() {
        return (TP)this.getBottomProtocol();
    }

    public static ConcurrentMap<String, Tuple<TP, RefCounter>> getSingletonTransports() {
        return singleton_transports;
    }

    @Override
    public Map<String, Object> dumpStats() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        for (Protocol p = this.top_prot; p != null; p = p.getDownProtocol()) {
            String prot_name = p.getName();
            Map<String, Object> tmp = p.dumpStats();
            if (prot_name == null || tmp == null) continue;
            retval.put(prot_name, tmp);
        }
        return retval;
    }

    public Map<String, Object> dumpStats(String protocol_name) {
        return this.dumpStats(protocol_name, null);
    }

    public Map<String, Object> dumpStats(String protocol_name, List<String> attrs) {
        Protocol prot = this.findProtocol(protocol_name);
        if (prot == null) {
            return null;
        }
        HashMap<String, Object> retval = new HashMap<String, Object>();
        Map<String, Object> tmp = prot.dumpStats();
        if (tmp != null) {
            if (attrs != null && !attrs.isEmpty()) {
                Iterator<String> it = tmp.keySet().iterator();
                while (it.hasNext()) {
                    String attrname = it.next();
                    boolean found = false;
                    for (String attr : attrs) {
                        if (!attrname.startsWith(attr)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    it.remove();
                }
            }
            retval.put(protocol_name, tmp);
        }
        return retval;
    }

    public String dumpTimerQueue() {
        TimeScheduler timer;
        TP transport = this.getTransport();
        if (transport != null && (timer = transport.getTimer()) != null) {
            return timer.dumpTimerTasks();
        }
        return "";
    }

    public String printProtocolSpec(boolean include_properties) {
        StringBuilder sb = new StringBuilder();
        List<Protocol> protocols = this.getProtocols();
        if (protocols == null || protocols.isEmpty()) {
            return null;
        }
        boolean first_colon_printed = false;
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            Map<String, String> tmp;
            String prot_name = prot.getClass().getName();
            int index = prot_name.indexOf("org.jgroups.protocols.");
            if (index >= 0) {
                prot_name = prot_name.substring("org.jgroups.protocols.".length());
            }
            if (first_colon_printed) {
                sb.append(":");
            } else {
                first_colon_printed = true;
            }
            sb.append(prot_name);
            if (!include_properties || (tmp = ProtocolStack.getProps(prot)).isEmpty()) continue;
            boolean printed = false;
            sb.append("(");
            for (Map.Entry<String, String> entry : tmp.entrySet()) {
                if (printed) {
                    sb.append(";");
                } else {
                    printed = true;
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    public String printProtocolSpecAsXML() {
        StringBuilder sb = new StringBuilder();
        Protocol prot = this.bottom_prot;
        int max_len = 30;
        sb.append("<config>\n");
        while (prot != null) {
            String prot_name = prot.getName();
            if (prot_name == null) continue;
            if ("ProtocolStack".equals(prot_name)) break;
            sb.append("  <").append(prot_name).append(" ");
            Map<String, String> tmpProps = ProtocolStack.getProps(prot);
            if (tmpProps != null) {
                int len = prot_name.length();
                for (Map.Entry<String, String> entry : tmpProps.entrySet()) {
                    String s = entry.getKey() + "=\"" + entry.getValue() + "\" ";
                    if (len + s.length() > max_len) {
                        sb.append("\n       ");
                        len = 8;
                    }
                    sb.append(s);
                    len += s.length();
                }
            }
            sb.append("/>\n");
            prot = prot.getUpProtocol();
        }
        sb.append("</config>");
        return sb.toString();
    }

    public String printProtocolSpecAsPlainString() {
        return this.printProtocolSpecAsPlainString(false);
    }

    private String printProtocolSpecAsPlainString(boolean print_props) {
        StringBuilder sb = new StringBuilder();
        List<Protocol> protocols = this.getProtocols();
        if (protocols == null) {
            return null;
        }
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            sb.append(prot.getClass().getName()).append("\n");
            if (!print_props) continue;
            Map<String, String> tmp = ProtocolStack.getProps(prot);
            for (Map.Entry<String, String> entry : tmp.entrySet()) {
                sb.append("    ").append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    private static Map<String, String> getProps(Protocol prot) {
        HashMap<String, String> retval = new HashMap<String, String>();
        for (Class<?> clazz = prot.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method[] methods;
            Property annotation;
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Object value;
                if (!field.isAnnotationPresent(Property.class) || (value = Configurator.getField(field, prot)) == null) continue;
                annotation = field.getAnnotation(Property.class);
                Class<?> conv_class = annotation.converter();
                PropertyConverter conv = null;
                try {
                    conv = (PropertyConverter)conv_class.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String tmp = conv != null ? conv.toString(value) : value.toString();
                retval.put(field.getName(), tmp);
            }
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Object value;
                String methodName = method.getName();
                if (!method.isAnnotationPresent(Property.class) || !Configurator.isSetPropertyMethod(method)) continue;
                annotation = method.getAnnotation(Property.class);
                LinkedList<String> possible_names = new LinkedList<String>();
                if (annotation.name() != null) {
                    possible_names.add(annotation.name());
                }
                possible_names.add(methodName.substring(3));
                possible_names.add(Util.methodNameToAttributeName(methodName));
                Field field = ProtocolStack.findField(prot, possible_names);
                if (field == null || (value = Configurator.getField(field, prot)) == null) continue;
                Class<?> conv_class = annotation.converter();
                PropertyConverter conv = null;
                try {
                    conv = (PropertyConverter)conv_class.newInstance();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String tmp = conv != null ? conv.toString(value) : value.toString();
                retval.put(field.getName(), tmp);
            }
        }
        return retval;
    }

    public void setup(List<ProtocolConfiguration> configs) throws Exception {
        if (this.top_prot == null) {
            this.top_prot = new Configurator(this).setupProtocolStack(configs);
            this.top_prot.setUpProtocol(this);
            this.setDownProtocol(this.top_prot);
            this.bottom_prot = this.getBottomProtocol();
            this.initProtocolStack();
        }
    }

    public void setup(ProtocolStack stack) throws Exception {
        if (this.top_prot == null) {
            this.top_prot = new Configurator(this).setupProtocolStack(stack);
            this.top_prot.setUpProtocol(this);
            this.setDownProtocol(this.top_prot);
            this.bottom_prot = this.getBottomProtocol();
            this.initProtocolStack();
        }
    }

    public ProtocolStack addProtocol(Protocol prot) {
        if (prot == null) {
            return this;
        }
        prot.setUpProtocol(this);
        if (this.bottom_prot == null) {
            this.top_prot = this.bottom_prot = prot;
            return this;
        }
        prot.setDownProtocol(this.top_prot);
        prot.getDownProtocol().setUpProtocol(prot);
        this.top_prot = prot;
        return this;
    }

    public ProtocolStack addProtocols(Protocol ... prots) {
        if (prots != null) {
            for (Protocol prot : prots) {
                this.addProtocol(prot);
            }
        }
        return this;
    }

    public ProtocolStack addProtocols(List<Protocol> prots) {
        if (prots != null) {
            for (Protocol prot : prots) {
                this.addProtocol(prot);
            }
        }
        return this;
    }

    public void insertProtocol(Protocol prot, int position, String neighbor_prot) throws Exception {
        if (neighbor_prot == null) {
            throw new IllegalArgumentException("neighbor_prot is null");
        }
        if (position != 1 && position != 2) {
            throw new IllegalArgumentException("position has to be ABOVE or BELOW");
        }
        Protocol neighbor = this.findProtocol(neighbor_prot);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol \"" + neighbor_prot + "\" not found in " + this.stack.printProtocolSpec(false));
        }
        if (position == 2 && neighbor instanceof TP) {
            throw new IllegalArgumentException("Cannot insert protocol " + prot.getName() + " below transport protocol");
        }
        this.insertProtocolInStack(prot, neighbor, position);
    }

    public void insertProtocolInStack(Protocol prot, Protocol neighbor, int position) {
        if (position == 2) {
            prot.setUpProtocol(neighbor);
            Protocol below = neighbor.getDownProtocol();
            prot.setDownProtocol(below);
            if (below != null) {
                below.setUpProtocol(prot);
            }
            neighbor.setDownProtocol(prot);
        } else {
            Protocol above = neighbor.getUpProtocol();
            this.checkAndSwitchTop(neighbor, prot);
            prot.setUpProtocol(above);
            if (above != null) {
                above.setDownProtocol(prot);
            }
            prot.setDownProtocol(neighbor);
            neighbor.setUpProtocol(prot);
        }
    }

    private void checkAndSwitchTop(Protocol oldTop, Protocol newTop) {
        if (oldTop == this.top_prot) {
            this.top_prot = newTop;
            this.top_prot.setUpProtocol(this);
        }
    }

    public void insertProtocol(Protocol prot, int position, Class<? extends Protocol> neighbor_prot) throws Exception {
        if (neighbor_prot == null) {
            throw new IllegalArgumentException("neighbor_prot is null");
        }
        if (position != 1 && position != 2) {
            throw new IllegalArgumentException("position has to be ABOVE or BELOW");
        }
        Protocol neighbor = this.findProtocol((Class<?>)neighbor_prot);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol \"" + neighbor_prot + "\" not found in " + this.stack.printProtocolSpec(false));
        }
        this.insertProtocolInStack(prot, neighbor, position);
    }

    public void insertProtocol(Protocol prot, int position, Class<? extends Protocol> ... neighbor_prots) throws Exception {
        if (neighbor_prots == null) {
            throw new IllegalArgumentException("neighbor_prots is null");
        }
        if (position != 1 && position != 2) {
            throw new IllegalArgumentException("position has to be ABOVE or BELOW");
        }
        Protocol neighbor = this.findProtocol(neighbor_prots);
        if (neighbor == null) {
            throw new IllegalArgumentException("protocol \"" + neighbor_prots.toString() + "\" not found in " + this.stack.printProtocolSpec(false));
        }
        this.insertProtocolInStack(prot, neighbor, position);
    }

    public void insertProtocolAtTop(Protocol prot) {
        if (prot == null) {
            throw new IllegalArgumentException("prot needs to be non-null");
        }
        Class<?> clazz = prot.getClass();
        Protocol existing_instance = this.findProtocol(clazz);
        if (existing_instance != null) {
            return;
        }
        this.top_prot.up_prot = prot;
        prot.down_prot = this.top_prot;
        prot.up_prot = this;
        this.top_prot = prot;
        if (this.log.isDebugEnabled()) {
            this.log.debug("inserted " + prot + " at the top of the stack");
        }
    }

    public Protocol removeProtocol(String prot_name) throws Exception {
        if (prot_name == null) {
            return null;
        }
        Protocol prot = this.findProtocol(prot_name);
        if (prot == null) {
            return null;
        }
        Protocol above = prot.getUpProtocol();
        Protocol below = prot.getDownProtocol();
        this.checkAndSwitchTop(prot, below);
        if (above != null) {
            above.setDownProtocol(below);
        }
        if (below != null) {
            below.setUpProtocol(above);
        }
        prot.setUpProtocol(null);
        prot.setDownProtocol(null);
        return prot;
    }

    public Protocol removeProtocol(Class ... protocols) {
        Protocol retval = null;
        if (protocols != null) {
            for (Class cl : protocols) {
                Protocol tmp = this.removeProtocol(cl);
                if (tmp == null) continue;
                retval = tmp;
            }
        }
        return retval;
    }

    public Protocol removeProtocol(Class prot) {
        if (prot == null) {
            return null;
        }
        Protocol retval = this.findProtocol((Class<?>)prot);
        if (retval == null) {
            return null;
        }
        Protocol above = retval.getUpProtocol();
        Protocol below = retval.getDownProtocol();
        this.checkAndSwitchTop(retval, below);
        if (above != null) {
            above.setDownProtocol(below);
        }
        if (below != null) {
            below.setUpProtocol(above);
        }
        retval.setUpProtocol(null);
        retval.setDownProtocol(null);
        return retval;
    }

    public Protocol findProtocol(String name) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            String prot_name = tmp.getName();
            if (prot_name == null || !prot_name.equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public Protocol getBottomProtocol() {
        Protocol curr_prot;
        for (curr_prot = this; curr_prot != null && curr_prot.getDownProtocol() != null; curr_prot = curr_prot.getDownProtocol()) {
        }
        return curr_prot;
    }

    public Protocol getTopProtocol() {
        return this.top_prot;
    }

    public Protocol findProtocol(Class<?> clazz) {
        for (Protocol tmp = this.top_prot; tmp != null; tmp = tmp.getDownProtocol()) {
            Class<?> protClass = tmp.getClass();
            if (!clazz.isAssignableFrom(protClass)) continue;
            return tmp;
        }
        return null;
    }

    public Protocol findProtocol(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            Protocol prot = this.findProtocol(clazz);
            if (prot == null) continue;
            return prot;
        }
        return null;
    }

    @Override
    public void init() throws Exception {
        List<Protocol> protocols = this.getProtocols();
        Collections.reverse(protocols);
        this.top_prot = Configurator.connectProtocols(protocols);
        this.top_prot.setUpProtocol(this);
        this.setDownProtocol(this.top_prot);
        this.bottom_prot = this.getBottomProtocol();
        Configurator.setDefaultValues(protocols);
        this.initProtocolStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initProtocolStack() throws Exception {
        List<Protocol> protocols = this.getProtocols();
        Collections.reverse(protocols);
        for (Protocol prot : protocols) {
            TP transport;
            if (prot instanceof TP && (transport = (TP)prot).isSingleton()) {
                String singleton_name = transport.getSingletonName();
                ConcurrentMap<String, Tuple<TP, RefCounter>> concurrentMap = singleton_transports;
                synchronized (concurrentMap) {
                    Tuple val = (Tuple)singleton_transports.get(singleton_name);
                    if (val == null) {
                        singleton_transports.put(singleton_name, new Tuple<TP, RefCounter>(transport, new RefCounter(1, 0)));
                    } else {
                        RefCounter counter = (RefCounter)val.getVal2();
                        short num_inits = counter.incrementInitCount();
                        if (num_inits >= 1) {
                            continue;
                        }
                    }
                }
            }
            prot.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (this.top_prot != null) {
            for (Protocol prot : this.getProtocols()) {
                TP transport;
                if (prot instanceof TP && (transport = (TP)prot).isSingleton()) {
                    String singleton_name = transport.getSingletonName();
                    ConcurrentMap<String, Tuple<TP, RefCounter>> concurrentMap = singleton_transports;
                    synchronized (concurrentMap) {
                        Tuple val = (Tuple)singleton_transports.get(singleton_name);
                        if (val != null) {
                            RefCounter counter = (RefCounter)val.getVal2();
                            short num_inits = counter.decrementInitCount();
                            if (num_inits >= 1) {
                                continue;
                            }
                            singleton_transports.remove(singleton_name);
                        }
                    }
                }
                prot.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStack(String cluster_name, Address local_addr) throws Exception {
        if (!this.stopped) {
            return;
        }
        Protocol above_prot = null;
        for (Protocol prot : this.getProtocols()) {
            if (prot instanceof TP) {
                String singleton_name = ((TP)prot).getSingletonName();
                TP transport = (TP)prot;
                if (transport.isSingleton() && cluster_name != null) {
                    ConcurrentMap<String, Protocol> up_prots = transport.getUpProtocols();
                    ConcurrentMap<String, Tuple<TP, RefCounter>> concurrentMap = singleton_transports;
                    synchronized (concurrentMap) {
                        ConcurrentMap<String, Protocol> concurrentMap2 = up_prots;
                        synchronized (concurrentMap2) {
                            Set keys = up_prots.keySet();
                            if (keys.contains(cluster_name)) {
                                throw new IllegalStateException("cluster '" + cluster_name + "' is already connected to singleton " + "transport: " + keys);
                            }
                            Iterator it = up_prots.entrySet().iterator();
                            while (it.hasNext()) {
                                Map.Entry entry = it.next();
                                Protocol tmp = (Protocol)entry.getValue();
                                if (tmp != above_prot) continue;
                                it.remove();
                            }
                            if (above_prot != null) {
                                TP.ProtocolAdapter ad = new TP.ProtocolAdapter(cluster_name, local_addr, prot.getId(), above_prot, prot, transport.getThreadNamingPattern());
                                ad.setProtocolStack(above_prot.getProtocolStack());
                                above_prot.setDownProtocol(ad);
                                up_prots.put(cluster_name, ad);
                            }
                        }
                        Tuple val = (Tuple)singleton_transports.get(singleton_name);
                        if (val != null) {
                            RefCounter counter = (RefCounter)val.getVal2();
                            short num_starts = counter.incrementStartCount();
                            if (num_starts >= 1) {
                                continue;
                            }
                            prot.start();
                            above_prot = prot;
                            continue;
                        }
                    }
                }
            }
            prot.start();
            above_prot = prot;
        }
        TP transport = this.getTransport();
        transport.registerProbeHandler(this.props_handler);
        this.stopped = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack(String cluster_name) {
        if (this.stopped) {
            return;
        }
        for (Protocol prot : this.getProtocols()) {
            TP transport;
            if (prot instanceof TP && (transport = (TP)prot).isSingleton()) {
                ConcurrentMap<String, Protocol> up_prots;
                String singleton_name = transport.getSingletonName();
                ConcurrentMap<String, Object> concurrentMap = up_prots = transport.getUpProtocols();
                synchronized (concurrentMap) {
                    up_prots.remove(cluster_name);
                }
                concurrentMap = singleton_transports;
                synchronized (concurrentMap) {
                    RefCounter counter;
                    short num_starts;
                    Tuple val = (Tuple)singleton_transports.get(singleton_name);
                    if (val != null && (num_starts = (counter = (RefCounter)val.getVal2()).decrementStartCount()) > 0) {
                        continue;
                    }
                }
            }
            prot.stop();
        }
        TP transport = this.getTransport();
        transport.unregisterProbeHandler(this.props_handler);
        this.stopped = true;
    }

    public void flushEvents() {
    }

    @Override
    public void send(Message msg) throws Exception {
        this.down(new Event(1, msg));
    }

    @Override
    public Object receive(long timeout) throws Exception {
        throw new Exception("ProtocolStack.receive(): not implemented !");
    }

    @Override
    public String getName() {
        return "ProtocolStack";
    }

    @Override
    public Object up(Event evt) {
        return this.channel.up(evt);
    }

    @Override
    public Object down(Event evt) {
        if (this.top_prot != null) {
            return this.top_prot.down(evt);
        }
        return null;
    }

    public static class RefCounter {
        private short init_count = 0;
        private short start_count = 0;

        public RefCounter(short init_count, short start_count) {
            this.init_count = init_count;
            this.start_count = start_count;
        }

        public short getInitCount() {
            return this.init_count;
        }

        public short getStartCount() {
            return this.start_count;
        }

        public short incrementInitCount() {
            short s = this.init_count;
            this.init_count = (short)(s + 1);
            return s;
        }

        public short decrementInitCount() {
            this.init_count = (short)Math.max(this.init_count - 1, 0);
            return this.init_count;
        }

        public short decrementStartCount() {
            this.start_count = (short)Math.max(this.start_count - 1, 0);
            return this.start_count;
        }

        public short incrementStartCount() {
            short s = this.start_count;
            this.start_count = (short)(s + 1);
            return s;
        }

        public String toString() {
            return "init_count=" + this.init_count + ", start_count=" + this.start_count;
        }
    }
}

