/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jgroups.Address;
import org.jgroups.Header;
import org.jgroups.util.Range;
import org.jgroups.util.Util;

public class NakAckHeader
extends Header {
    public static final byte MSG = 1;
    public static final byte XMIT_REQ = 2;
    public static final byte XMIT_RSP = 3;
    byte type = 0;
    long seqno = -1L;
    Range range = null;
    Address sender;

    public NakAckHeader() {
    }

    public static NakAckHeader createMessageHeader(long seqno) {
        return new NakAckHeader(1, seqno);
    }

    public static NakAckHeader createXmitRequestHeader(long low, long high, Address orginal_sender) {
        return new NakAckHeader(2, low, high, orginal_sender);
    }

    public static NakAckHeader createXmitResponseHeader() {
        return new NakAckHeader(3, -1L);
    }

    private NakAckHeader(byte type, long seqno) {
        this.type = type;
        this.seqno = seqno;
    }

    private NakAckHeader(byte type, long low, long high, Address sender) {
        this.type = type;
        this.range = new Range(low, high);
        this.sender = sender;
    }

    public byte getType() {
        return this.type;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public Range getRange() {
        return this.range;
    }

    public Address getSender() {
        return this.sender;
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        out.writeByte(this.type);
        switch (this.type) {
            case 1: {
                out.writeLong(this.seqno);
                break;
            }
            case 2: {
                Util.writeStreamable(this.range, out);
                Util.writeAddress(this.sender, out);
                break;
            }
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        this.type = in.readByte();
        switch (this.type) {
            case 1: {
                this.seqno = in.readLong();
                break;
            }
            case 2: {
                this.range = (Range)Util.readStreamable(Range.class, in);
                this.sender = Util.readAddress(in);
                break;
            }
        }
    }

    @Override
    public int size() {
        int retval = 1;
        switch (this.type) {
            case 1: {
                return retval + 8;
            }
            case 2: {
                ++retval;
                if (this.range != null) {
                    retval += 16;
                }
                return retval += Util.size(this.sender);
            }
            case 3: {
                return retval;
            }
        }
        return retval;
    }

    public NakAckHeader copy() {
        NakAckHeader ret = new NakAckHeader();
        ret.type = this.type;
        ret.seqno = this.seqno;
        ret.range = this.range;
        ret.sender = this.sender;
        return ret;
    }

    public static String type2Str(byte t) {
        switch (t) {
            case 1: {
                return "MSG";
            }
            case 2: {
                return "XMIT_REQ";
            }
            case 3: {
                return "XMIT_RSP";
            }
        }
        return "<undefined>";
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("[").append(NakAckHeader.type2Str(this.type));
        switch (this.type) {
            case 1: {
                ret.append(", seqno=").append(this.seqno);
                break;
            }
            case 2: {
                if (this.range == null) break;
                ret.append(", range=" + this.range);
                break;
            }
        }
        if (this.sender != null) {
            ret.append(", sender=").append(this.sender);
        }
        ret.append(']');
        return ret.toString();
    }
}

