/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _ComponentAttributesMap
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = -9106832179394257866L;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private UIComponent _component;
    private transient Map<String, PropertyDescriptor> _propertyDescriptorMap = null;
    private static Map<Class<?>, Map<String, PropertyDescriptor>> _propertyDescriptorCache = new WeakHashMap();

    _ComponentAttributesMap(UIComponent component) {
        this._component = component;
    }

    @Override
    public int size() {
        return this.getUnderlyingMap().size();
    }

    @Override
    public void clear() {
        this.getUnderlyingMap().clear();
    }

    @Override
    public boolean isEmpty() {
        return this.getUnderlyingMap().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        this.checkKey(key);
        return this.getPropertyDescriptor((String)key) == null ? this.getUnderlyingMap().containsKey(key) : false;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getUnderlyingMap().containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return this.getUnderlyingMap().values();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        for (Map.Entry<? extends String, ? extends Object> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.getUnderlyingMap().entrySet();
    }

    @Override
    public Set<String> keySet() {
        return this.getUnderlyingMap().keySet();
    }

    @Override
    public Object get(Object key) {
        Object value;
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((String)key);
        if (propertyDescriptor != null) {
            value = this.getComponentProperty(propertyDescriptor);
        } else {
            value = this.getUnderlyingMap().get(key);
            if (value == null) {
                ValueExpression ve = this._component.getValueExpression((String)key);
                if (ve != null) {
                    value = ve.getValue(this._component.getFacesContext().getELContext());
                } else {
                    return null;
                }
            }
        }
        return value;
    }

    @Override
    public Object remove(Object key) {
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((String)key);
        if (propertyDescriptor != null) {
            throw new IllegalArgumentException("Cannot remove component property attribute");
        }
        return this._component.getStateHelper().remove((Serializable)((Object)UIComponent.PropertyKeys.attributesMap), key);
    }

    @Override
    public Object put(String key, Object value) {
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(key);
        if (propertyDescriptor == null) {
            if (value == null) {
                throw new NullPointerException("value is null for a not available property: " + key);
            }
        } else {
            if (propertyDescriptor.getReadMethod() != null) {
                Object oldValue = this.getComponentProperty(propertyDescriptor);
                this.setComponentProperty(propertyDescriptor, value);
                return oldValue;
            }
            this.setComponentProperty(propertyDescriptor, value);
            return null;
        }
        return this._component.getStateHelper().put((Serializable)((Object)UIComponent.PropertyKeys.attributesMap), key, value);
    }

    private PropertyDescriptor getPropertyDescriptor(String key) {
        if (this._propertyDescriptorMap == null) {
            this._propertyDescriptorMap = _propertyDescriptorCache.get(this._component.getClass());
            if (this._propertyDescriptorMap == null) {
                BeanInfo beanInfo;
                try {
                    beanInfo = Introspector.getBeanInfo(this._component.getClass());
                }
                catch (IntrospectionException e) {
                    throw new FacesException(e);
                }
                PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
                this._propertyDescriptorMap = new HashMap<String, PropertyDescriptor>();
                for (int i = 0; i < propertyDescriptors.length; ++i) {
                    PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                    if (propertyDescriptor.getReadMethod() == null) continue;
                    this._propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
                }
                _propertyDescriptorCache.put(this._component.getClass(), this._propertyDescriptorMap);
            }
        }
        return this._propertyDescriptorMap.get(key);
    }

    private Object getComponentProperty(PropertyDescriptor propertyDescriptor) {
        Method readMethod = propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            throw new IllegalArgumentException("Component property " + propertyDescriptor.getName() + " is not readable");
        }
        try {
            return readMethod.invoke((Object)this._component, EMPTY_ARGS);
        }
        catch (Exception e) {
            FacesContext facesContext = this._component.getFacesContext();
            throw new FacesException("Could not get property " + propertyDescriptor.getName() + " of component " + this._component.getClientId(facesContext), e);
        }
    }

    private void setComponentProperty(PropertyDescriptor propertyDescriptor, Object value) {
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("Component property " + propertyDescriptor.getName() + " is not writable");
        }
        try {
            writeMethod.invoke((Object)this._component, value);
        }
        catch (Exception e) {
            FacesContext facesContext = this._component.getFacesContext();
            throw new FacesException("Could not set property " + propertyDescriptor.getName() + " of component " + this._component.getClientId(facesContext) + " to value : " + value + " with type : " + (value == null ? "null" : value.getClass().getName()), e);
        }
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is not a String");
        }
    }

    Map<String, Object> getUnderlyingMap() {
        Map _attributes = (Map)this._component.getStateHelper().get((Serializable)((Object)UIComponent.PropertyKeys.attributesMap));
        return _attributes == null ? Collections.EMPTY_MAP : _attributes;
    }

    @Override
    public boolean equals(Object obj) {
        return ((Object)this.getUnderlyingMap()).equals(obj);
    }

    @Override
    public int hashCode() {
        return ((Object)this.getUnderlyingMap()).hashCode();
    }
}

