/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.EventObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.ha.framework.interfaces.ClusterNode;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HASingleton;
import org.jboss.ha.framework.interfaces.HASingletonElectionPolicy;
import org.jboss.ha.framework.interfaces.HASingletonLifecycle;
import org.jboss.ha.framework.server.EventFacility;
import org.jboss.ha.framework.server.EventFactory;
import org.jboss.ha.framework.server.HAServiceImpl;
import org.jboss.ha.framework.server.HAServiceRpcHandler;
import org.jboss.ha.framework.server.HASingletonRpcHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HASingletonImpl<E extends EventObject>
extends HAServiceImpl<E>
implements HASingleton<E>,
HASingletonRpcHandler<E> {
    private final AtomicBoolean master = new AtomicBoolean(false);
    private final HASingletonRpcHandler<E> rpcHandler = new RpcHandler();
    private final HASingletonLifecycle singletonLifecycle;
    AtomicReference<ReplicantView> viewReference = new AtomicReference();
    private volatile HASingletonElectionPolicy electionPolicy;
    private volatile boolean restartOnMerge = true;

    public HASingletonImpl(EventFactory<E> eventFactory, EventFacility<E> eventHandler, HASingletonLifecycle singletonLifecycle) {
        super(eventFactory, eventHandler);
        this.singletonLifecycle = singletonLifecycle;
    }

    public HASingletonImpl(EventFactory<E> eventFactory) {
        super(eventFactory);
        this.singletonLifecycle = this;
    }

    @Override
    public HASingletonElectionPolicy getElectionPolicy() {
        return this.electionPolicy;
    }

    @Override
    public void setElectionPolicy(HASingletonElectionPolicy electionPolicy) {
        this.electionPolicy = electionPolicy;
    }

    @Override
    public boolean getRestartOnMerge() {
        return this.restartOnMerge;
    }

    @Override
    public void setRestartOnMerge(boolean restart) {
        this.restartOnMerge = restart;
    }

    @Override
    public boolean isMasterNode() {
        return this.master.get();
    }

    @Override
    protected void registerDRMListener() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HASingletonImpl.registerDRMListener for service=" + this.getHAServiceKey()));
        }
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        RecordingReplicantListener listener = new RecordingReplicantListener();
        String key = this.getHAServiceKey();
        drm.registerListener(key, listener);
        drm.add(key, this.getReplicant());
        drm.registerListener(key, this);
        drm.unregisterListener(key, listener);
        ReplicantView view = this.viewReference.getAndSet(null);
        if (view != null) {
            this.partitionTopologyChanged(view.getReplicants(), view.getId(), view.isMerge());
        }
    }

    @Override
    public void startSingleton() {
        this.log.debug((Object)"startSingleton() : elected for master singleton node");
    }

    @Override
    public void stopSingleton() {
        this.log.debug((Object)"stopSingleton() : another node in the partition (if any) is elected for master");
    }

    @Override
    protected void partitionTopologyChanged(List<?> newReplicants, int newViewId, boolean merge) {
        ReplicantView view = this.viewReference.getAndSet(null);
        if (view != null) {
            this.partitionTopologyChanged(view.getReplicants(), view.getId(), view.isMerge());
        }
        boolean isElectedNewMaster = this.elected();
        boolean isMaster = this.master.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("partitionTopologyChanged, isElectedNewMaster=" + isElectedNewMaster + ", isMasterNode=" + isMaster + ", viewID=" + newViewId + ", partition=" + this.getHAPartition().getPartitionName()));
        }
        if (isElectedNewMaster) {
            if (isMaster) {
                if (this.restartOnMerge && merge) {
                    this.restartMaster();
                }
            } else {
                this.makeThisNodeMaster();
            }
        } else if (isMaster) {
            this.stopIfMaster();
        }
    }

    private boolean elected() {
        boolean result;
        if (this.electionPolicy == null) {
            result = this.isDRMMasterReplica();
        } else {
            ClusterNode electedNode = this.election();
            boolean bl = result = electedNode != null ? electedNode.equals(this.getHAPartition().getClusterNode()) : false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("election result =" + result + ", electionPolicy=" + (this.electionPolicy != null ? this.electionPolicy.getClass().getName() : "DistributedReplicantManager")));
        }
        return result;
    }

    private ClusterNode election() {
        List<ClusterNode> candidates = this.getElectionCandidates();
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        return candidates.size() == 1 ? candidates.get(0) : this.electionPolicy.elect(candidates);
    }

    protected List<ClusterNode> getElectionCandidates() {
        return this.getHAPartition().getDistributedReplicantManager().lookupReplicantsNodes(this.getHAServiceKey());
    }

    @Override
    public void stopOldMaster() throws Exception {
        this.callAsyncMethodOnPartition("stopOldMaster", new Object[0], new Class[0]);
    }

    protected boolean isDRMMasterReplica() {
        DistributedReplicantManager drm = this.getHAPartition().getDistributedReplicantManager();
        return drm.isMasterReplica(this.getHAServiceKey());
    }

    protected void makeThisNodeMaster() {
        try {
            this.stopOldMaster();
            this.startNewMaster();
        }
        catch (Exception ex) {
            this.log.error((Object)"stopOldMaster failed. New master singleton will not start.", (Throwable)ex);
            ex.printStackTrace(System.err);
        }
    }

    protected void startNewMaster() {
        this.log.debug((Object)("startNewMaster, isMasterNode=" + this.master));
        this.master.set(true);
        this.sendLocalEvent("org.jboss.ha.singleton.starting");
        this.singletonLifecycle.startSingleton();
        this.sendLocalEvent("org.jboss.ha.singleton.started");
    }

    protected void restartMaster() {
        this.stopIfMaster();
        this.startNewMaster();
    }

    protected void stopIfMaster() {
        this.log.debug((Object)("stopIfMaster, isMasterNode=" + this.master.get()));
        try {
            if (this.master.compareAndSet(true, false)) {
                this.sendLocalEvent("org.jboss.ha.singleton.stopping");
                this.singletonLifecycle.stopSingleton();
                this.sendLocalEvent("org.jboss.ha.singleton.stopped");
            }
        }
        catch (Exception ex) {
            this.log.error((Object)"stopIfMaster failed. Will still try to start new master. You need to examine the reason why the old master wouldn't stop and resolve it. It is bad that the old singleton may still be running while we are starting a new one, so you need to resolve this ASAP.", (Throwable)ex);
        }
    }

    private void sendLocalEvent(String type) {
        Object event = this.getEventFactory().createEvent(this, type);
        try {
            this.getEventFacility().notifyListeners(event);
        }
        catch (Exception e) {
            this.log.warn((Object)("Failed to send local event: " + event), (Throwable)e);
        }
    }

    @Override
    protected HAServiceRpcHandler<E> getRpcHandler() {
        return this.rpcHandler;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RecordingReplicantListener
    implements DistributedReplicantManager.ReplicantListener {
        RecordingReplicantListener() {
        }

        @Override
        public void replicantsChanged(String key, List<?> newReplicants, int newReplicantsViewId, boolean merge) {
            if (HASingletonImpl.this.getHAServiceKey().equals(key)) {
                HASingletonImpl.this.viewReference.set(new ReplicantView(newReplicants, newReplicantsViewId, merge));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReplicantView {
        private List<?> replicants;
        private int id;
        private boolean merge;

        public ReplicantView(List<?> replicants, int viewId, boolean merge) {
            this.replicants = replicants;
            this.id = viewId;
            this.merge = merge;
        }

        public List<?> getReplicants() {
            return this.replicants;
        }

        public int getId() {
            return this.id;
        }

        public boolean isMerge() {
            return this.merge;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RpcHandler
    extends HAServiceImpl.RpcHandler
    implements HASingletonRpcHandler<E> {
        protected RpcHandler() {
        }

        @Override
        public void stopOldMaster() {
            HASingletonImpl.this.stopIfMaster();
        }
    }
}

