/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.resource.provider;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.switchboard.impl.resource.IndependentResource;
import org.jboss.switchboard.impl.resource.LinkRefResource;
import org.jboss.switchboard.javaee.environment.JavaEEResourceType;
import org.jboss.switchboard.javaee.environment.ResourceRefType;
import org.jboss.switchboard.javaee.jboss.environment.JBossResourceRefType;
import org.jboss.switchboard.javaee.util.InjectionTargetUtil;
import org.jboss.switchboard.mc.spi.MCBasedResourceProvider;
import org.jboss.switchboard.spi.Resource;

public class URLResourceProvider
implements MCBasedResourceProvider<JBossResourceRefType> {
    private static Logger logger = Logger.getLogger(URLResourceProvider.class);

    public Class<JBossResourceRefType> getEnvironmentEntryType() {
        return JBossResourceRefType.class;
    }

    public Resource provide(DeploymentUnit unit, JBossResourceRefType resRef) {
        String type = this.getResourceRefType(unit.getClassLoader(), (ResourceRefType)resRef);
        if (!URL.class.getName().equals(type)) {
            return null;
        }
        String url = resRef.getResourceURL();
        if (url != null && !url.trim().isEmpty()) {
            try {
                return new IndependentResource((Object)new URL(url.trim()));
            }
            catch (MalformedURLException murle) {
                throw new RuntimeException(murle);
            }
        }
        String mappedName = resRef.getMappedName();
        if (mappedName == null || mappedName.trim().isEmpty()) {
            throw new RuntimeException("Cannot create a resource out of resource-ref: " + resRef.getName() + " because neither non-empty res-url nor non-empty mapped-name is specified");
        }
        try {
            URL urlFromMappedName = new URL(mappedName.trim());
            return new IndependentResource((Object)urlFromMappedName);
        }
        catch (MalformedURLException murle) {
            logger.debug((Object)("mapped-name " + mappedName + " for URL resource-ref: " + resRef.getName() + " is malformed. mapped-name will now be treated as a jndi-name"));
            return new LinkRefResource(mappedName.trim());
        }
    }

    private String getResourceRefType(ClassLoader cl, ResourceRefType resourceRef) {
        String explicitType = resourceRef.getResourceType();
        if (explicitType != null && !explicitType.isEmpty()) {
            return explicitType;
        }
        Class type = InjectionTargetUtil.getInjectionTargetPropertyType((ClassLoader)cl, (JavaEEResourceType)resourceRef);
        return type == null ? null : type.getName();
    }
}

