/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.switchboard.mc.dependency;

import java.util.Map;
import org.jboss.beans.metadata.plugins.AbstractDependencyMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.switchboard.impl.resource.JNDIDependency;
import org.jboss.switchboard.mc.SwitchBoardImpl;
import org.jboss.switchboard.mc.dependency.JNDIDependencyItem;
import org.jboss.switchboard.mc.dependency.NameBasedDependencyItem;
import org.jboss.switchboard.spi.Resource;

public class SwitchBoardDependencyMetaData
extends AbstractDependencyMetaData {
    private static final long serialVersionUID = 1L;
    private boolean isJNDIDependency;
    private JNDIDependency jndiDependency;
    private SwitchBoardImpl switchBoard;
    private ControllerState whenRequired;
    private ControllerState dependentState;

    public SwitchBoardDependencyMetaData(SwitchBoardImpl switchBoard, Object dependency, ControllerState whenRequired, ControllerState dependentState) {
        super(dependency);
        this.switchBoard = switchBoard;
        this.whenRequired = whenRequired;
        this.dependentState = dependentState;
        if (dependency instanceof JNDIDependency) {
            this.isJNDIDependency = true;
            this.jndiDependency = (JNDIDependency)dependency;
        }
    }

    public void initialVisit(MetaDataVisitor visitor) {
        if (this.isJNDIDependency) {
            String jndiName = this.jndiDependency.getJNDIName();
            JNDIDependencyItem jndiDependencyItem = new JNDIDependencyItem(this.switchBoard, jndiName, this.whenRequired, this.dependentState, this.isResponsibleForBinding(jndiName));
            visitor.addDependency((DependencyItem)jndiDependencyItem);
            visitor.initialVisit((MetaDataVisitorNode)this);
        } else {
            KernelControllerContext context = visitor.getControllerContext();
            NameBasedDependencyItem item = new NameBasedDependencyItem(context.getName(), this.dependency, this.whenRequired, this.dependentState);
            visitor.addDependency((DependencyItem)item);
            visitor.initialVisit((MetaDataVisitorNode)this);
        }
    }

    private boolean isResponsibleForBinding(String jndiName) {
        Map<String, Resource> bindings = this.switchBoard.getBindings();
        if (bindings.containsKey(jndiName)) {
            return true;
        }
        if (jndiName.startsWith("java:comp/")) {
            String jndiNameWithoutNamespace = jndiName.substring("java:comp/".length());
            return bindings.containsKey(jndiNameWithoutNamespace);
        }
        return false;
    }
}

