/*
 * Decompiled with CFR 0.152.
 */
package mazz.i18n.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mazz.i18n.Msg;
import mazz.i18n.annotation.I18NMessage;
import mazz.i18n.annotation.I18NResourceBundle;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Echo;

@I18NResourceBundle(baseName="i18n-anttask-messages", defaultLocale="en")
public class I18NMessageAntTask
extends Echo {
    static final Msg.BundleBaseName BUNDLE_BASE_NAME = new Msg.BundleBaseName("i18n-anttask-messages");
    @I18NMessage(value="Missing the message key to the i18n message (the 'message' attribute)")
    static final String I18NMSG_MISSING_MESSAGE = "I18NMessageAntTask.missing-message-key";
    private Msg.BundleBaseName m_bundle;
    private Locale m_locale;
    private String m_property;
    private List<Arg> m_arguments = new ArrayList<Arg>();

    public void setBundle(Msg.BundleBaseName bundle) {
        this.m_bundle = bundle;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setProperty(String property) {
        this.m_property = property;
    }

    public Arg createArg() {
        Arg arg = new Arg();
        this.m_arguments.add(arg);
        return arg;
    }

    public void execute() throws BuildException {
        this.validateTaskConfiguration();
        this.message = this.message.replaceAll("\r\n", "").replaceAll("\n", "").trim();
        this.message = Msg.createMsg(this.m_bundle, this.m_locale, this.message, this.m_arguments.toArray()).toString();
        if (this.m_property != null) {
            Project proj = this.getOwningTarget().getProject();
            proj.setNewProperty(this.m_property, this.message);
        } else {
            super.execute();
        }
    }

    private void validateTaskConfiguration() throws BuildException {
        if (this.message == null) {
            throw new BuildException(Msg.createMsg(BUNDLE_BASE_NAME, I18NMSG_MISSING_MESSAGE, new Object[0]).toString());
        }
    }

    public class Arg
    extends Task {
        private String value = null;

        public void setValue(String v) {
            this.value = v;
        }

        public String toString() {
            return this.value;
        }
    }
}

