/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.ha;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.ha.framework.interfaces.HAServiceKeyProvider;
import org.jboss.ha.framework.interfaces.HASingletonMBean;
import org.jboss.logging.Logger;
import org.jboss.modcluster.Strings;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.ha.rpc.ResetRequestSourceRpcHandler;
import org.jboss.modcluster.ha.rpc.RpcResponse;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.ResetRequestSource;
import org.jboss.modcluster.mcmp.impl.ResetRequestSourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusteredResetRequestSource
extends ResetRequestSourceImpl {
    static final String METHOD_NAME = "getResetRequests";
    static final Class<?>[] TYPES = new Class[]{Map.class};
    private static final Logger log = Logger.getLogger(ClusteredResetRequestSource.class);
    private final HASingletonMBean singleton;
    private final ResetRequestSourceRpcHandler<List<RpcResponse<List<MCMPRequest>>>> rpcStub;

    public ClusteredResetRequestSource(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, MCMPRequestFactory requestFactory, HASingletonMBean singleton, HAServiceKeyProvider serviceKeyProvider) {
        super(nodeConfig, balancerConfig, requestFactory);
        this.singleton = singleton;
        this.rpcStub = new RpcStub(serviceKeyProvider);
    }

    @Override
    public List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> infoResponse) {
        List<MCMPRequest> resets = super.getResetRequests(infoResponse);
        if (this.singleton.isMasterNode()) {
            List<RpcResponse<List<MCMPRequest>>> responses = this.rpcStub.getResetRequests(infoResponse);
            for (RpcResponse<List<MCMPRequest>> response : responses) {
                try {
                    List<MCMPRequest> result = response.getResult();
                    if (result == null) continue;
                    resets.addAll(result);
                }
                catch (RuntimeException e) {
                    log.warn((Object)Strings.ERROR_RPC_KNOWN.getString(METHOD_NAME, response.getSender()), (Throwable)e);
                }
            }
        }
        return resets;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RpcStub
    implements ResetRequestSourceRpcHandler<List<RpcResponse<List<MCMPRequest>>>> {
        private final HAServiceKeyProvider serviceKeyProvider;

        RpcStub(HAServiceKeyProvider serviceKeyProvider) {
            this.serviceKeyProvider = serviceKeyProvider;
        }

        @Override
        public List<RpcResponse<List<MCMPRequest>>> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
            try {
                return this.serviceKeyProvider.getHAPartition().callMethodOnCluster(this.serviceKeyProvider.getHAServiceKey(), ClusteredResetRequestSource.METHOD_NAME, new Object[]{response}, (Class[])TYPES, true);
            }
            catch (Exception e) {
                throw Utils.convertToUnchecked(e);
            }
        }
    }
}

